/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MutableCollection=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),console_1=require("console"),node_state_1=require("../node-state"),state_get_value_1=require("../node-state/state-get-value"),state_intern_1=require("../node-state/state-intern"),state_invalidate_1=require("../node-state/state-invalidate"),state_utils_1=require("../node-state/state-utils"),ts_api_1=require("../ts-api"),base_collection_1=require("./base-collection");class MutableCollection extends base_collection_1.BaseCollection{get isVitalCollectionChild(){return this.factory.isVitalCollectionChild}get isAssociationChild(){return this.factory.isAssociationChild}get hasSortValue(){return this.isVitalCollectionChild&&!this.isAssociationChild}getQueryForUpdate(t){if(void 0!==t?.forUpdate)return t?.forUpdate;if(this.property.isMutable)return this.sourceState.forUpdate||"external"===this.factory.storage&&this.sourceState.status===node_state_1.StateStatus.inserted;return false}getReader(){return new xtrem_async_helper_1.AsyncArrayReader(async()=>{if(!this._nodes)this._nodes=await this.queryFullCollection();return this.getSource()})}async checkWritable(){if(this.sourceState.isReadonly)throw this.error("cannot modify collection of readonly node");if(!this.property.isOwnedByCustomer&&!xtrem_config_1.ConfigManager.current.ignoreVendorProtection&&this.factory.isVitalChild&&this.factory.vitalParentFactory.hasVendorProperty&&await this.sourceState.vendor)throw this.sourceState.propertyDataInputError(this.property,{message:"Cannot add to or delete from vendor protected collections.",key:"@sage/xtrem-core/cannot-modify-collection-protected-by-a-vendor"})}async createNode(t,e){const a=MutableCollection.fillPath(t,e);let i;return await state_utils_1.StateUtils.withValidationErrorRethrow(this.sourceNode.$.state,this.property,a,async()=>{i=(await node_state_1.NodeState.newFromContextCreate(this.sourceNode.$.context,this.factory,a,{...e,...await this.joinValues},{writable:true,isTransient:this.sourceState.isTransient||this.property.isTransientInput,isOnlyForDefaultValues:this.sourceState.isOnlyForDefaultValues,isOnlyForDuplicate:this.sourceState.isOnlyForDuplicate,isOnlyForLookup:this.sourceState.isOnlyForLookup,collection:this})).node}),i}async invalidateSourceNode(){if(this.sourceState.status===node_state_1.StateStatus.updatable)this.sourceState.status=node_state_1.StateStatus.modified;await state_invalidate_1.StateInvalidate.invalidateDependantProperties(this.sourceState,this.property)}async spliceWithNodes(t,e,a=[]){await this.invalidateSourceNode(),a.forEach(t=>{if(t.$.state.collection&&t.$.state.collection!==this)throw new Error(`${t.$.keyToken}: invalid attempt to associate this node with two collections: ${this.fullName} and ${t.$.state.collection.fullName}`);t.$.state.collection=this});(await this.nodes).splice(t,e,...a).forEach(t=>{t.$.state.collection=void 0})}static async allocateSortValues(t,e,a,i){if(!t.isVitalCollectionChild||t.isAssociationChild)return;await(0,xtrem_shared_1.setSortValues)({length:e.length,setSortValue:(t,a)=>e[t].$.state.setSortValue(a),getSortValue:t=>e[t].$.state.sortValue},a,i,{preserveOldValues:t.naturalKey?.includes("_sortValue")})}async allocateSortValues(t,e){await MutableCollection.allocateSortValues(this.factory,await this.nodes,t,e)}async spliceWithData(t,e,a=[]){await this.spliceWithNodes(t,e,await(0,xtrem_async_helper_1.asyncArray)(a).map(t=>this.createNode([this.property.name],t)).toArray()),await this.allocateSortValues(t,t+a.length-e)}async reset(){if(await this.checkWritable(),this._nodes&&this._nodes.length>0)this._nodes.forEach(t=>{t.$.state.collection=void 0});this._nodes=[]}async fill(t){await this.reset(),await this.spliceWithData(0,0,t)}async insert(t,e){await this.checkWritable(),await this.spliceWithData(t,0,[e])}async appendNode(t){await this.checkWritable(),await this.spliceWithNodes((await this.nodes).length,0,[t])}async append(t){await this.checkWritable(),await this.spliceWithData((await this.nodes).length,0,[t])}async delete(t,e=1){await this.checkWritable(),await this.spliceWithData(t,e)}async allocateSortValuesForInsertedNodes(t,e,a){const i=[];let s;for(let o=e;o<a;o+=1)if(void 0!==t[o]){if(s)s.end=o,i.push(s),s=void 0}else if(!s)s={start:o};if(s)s.end=a,i.push(s);await(0,xtrem_async_helper_1.asyncArray)(i.reverse()).forEach(t=>this.allocateSortValues(t.start,t.end))}async updateSortValues(t){if(!this.hasSortValue)return;let e=0,a=-1/0;for(;e<t.length&&(void 0===t[e]||t[e]>a);){if(void 0!==t[e])a=t[e];e+=1}if(e===t.length)return void await this.allocateSortValuesForInsertedNodes(t,0,t.length);for(e-=1;e>=0&&void 0===t[e];)e-=1;(0,console_1.assert)(e>=0);let i=t.length-1,s=1/0;for(;i>=0&&(void 0===t[i]||t[i]<s);){if(void 0!==t[i])s=t[i];i-=1}for((0,console_1.assert)(i>=0),i+=1;i<t.length&&void 0===t[i];)i+=1;if((0,console_1.assert)(i<t.length),e>=t.length-1-i)for(;i<t.length&&(void 0===t[i]||!(t[e]<t[i]));)i+=1;else for(;e>=0&&(void 0===t[e]||!(t[e]<t[i]));)e-=1;await this.allocateSortValuesForInsertedNodes(t,i,t.length),await this.allocateSortValues(e+1,i),await this.allocateSortValuesForInsertedNodes(t,0,e)}mixedFullPartialError(){return this.error("invalid update data: mix of rows with and without _action")}async deleteOldNodes(t){if("external"!==this.factory.storage&&!this.property.isTransientInput)await(0,xtrem_async_helper_1.asyncArray)(Object.keys(t)).forEach(async e=>{const a=t[e];if(!a.isNew){const t=a.getKeyValues();await this.factory.deleteMany(this.sourceState.context,t)}else state_intern_1.StateIntern.removeState(a)})}async _forceLazyloadingForSourceOld(){if(this.sourceNode.$.status===ts_api_1.NodeStatus.added)return;const t=await this.sourceNode.$.old,e=state_get_value_1.StateGetValue.getCollectionValue(t.$.state,this.property);await e.length}findOldTokenFromData(t,e){const a=Object.values(state_intern_1.StateIntern.getInterningKeysFromValues(this.factory,t));return Object.keys(e).find(t=>e[t].interningKeyValues.some(t=>a.includes(t)))}async fullUpdate(t,e,a,i){await this.reset();const s=Array(e.length);await(0,xtrem_async_helper_1.asyncArray)(e).forEach(async(e,o)=>{if(null!=e._action)throw this.mixedFullPartialError();const r={...a,...e},l=this.findOldTokenFromData(r,i);if(l){const a=i[l];if(this.hasSortValue)s[o]=await a.sortValue;await a.set(e,MutableCollection.fillPath(t,e)),await this.spliceWithNodes(o,0,[a.node]),delete i[l]}else{if(this.hasSortValue)s[o]=e._sortValue;await this.spliceWithNodes(o,0,[await this.createNode(t,r)])}}),await this.updateSortValues(s),await this._forceLazyloadingForSourceOld(),await this.deleteOldNodes(i)}appendedNodeNotInTailError(){return this.error("invalid update array: some new entries without _sortValue are not at the end of the list")}async compareSortValues(t,e){const a=await t.$.state.sortValue,i=await e.$.state.sortValue;if(a===i)throw this.error(`cannot update collection: duplicate _sortValue ${a}`);return a-i}static fillPath(t,e){return[...t,null!=e._id?String(e._id):""]}async partialUpdate(t,e,a,i){let s=false;const o=[],r=[];if(this._nodes=await this.nodes,e.length>0)await this.invalidateSourceNode();if(await(0,xtrem_async_helper_1.asyncArray)(e).forEach(async e=>{s=await this.partialUpdateAction(e,t,o,r,a,i)}),o.length>0)this._nodes=this._nodes.filter(t=>!o.includes(t));if(s)await this.sortBySortValue();this._nodes.push(...r),await this.allocateSortValues(this._nodes.length-r.length,this._nodes.length)}async partialUpdateAction(t,e,a,i,s,o){let r=false;const l={...t},n=l._action;if(null==n)throw this.mixedFullPartialError();if("string"!=typeof n)throw this.error("_action in update data must be a string, got "+typeof n);delete l._action;const c={...s,...l},h=this.findOldTokenFromData(c,o),d=h?o[h]:void 0;switch(n){case"create":{if(await this.checkWritable(),d)throw this.error(`cannot create entry: ${h} already exists`);const t=await this.createNode(e,c);if(l._sortValue){if(i.length>0)throw this.appendedNodeNotInTailError();this._nodes.push(t),r=true}else i.push(t);await this.invalidateSourceNode();break}case"update":if(!d)throw this.error(`cannot update entry: ${JSON.stringify(l)} not found`);if(i.length>0)throw this.appendedNodeNotInTailError();if(null!=l._sortValue&&l._sortValue!==await d.sortValue)r=true;await d.set(l,MutableCollection.fillPath(e,c)),delete o[h];break;case"delete":if(await this.checkWritable(),!d)throw this.error(`cannot delete entry: ${JSON.stringify(l)} not found`);await state_utils_1.StateUtils.withValidationErrorRethrow(this.sourceNode.$.state,this.property,MutableCollection.fillPath(e,c),async()=>{if(!d.isNew){await this._forceLazyloadingForSourceOld(),await d.delete({path:e});const t=this._nodes.indexOf(d.node);if(t>=0)await this.delete(t)}else state_intern_1.StateIntern.removeState(d);a.push(d.node),delete o[h]}),await this.invalidateSourceNode();break;default:throw this.error(`invalid _action in update data: ${n}`)}return r}async sortBySortValue(){if(!this.hasSortValue)return;await(0,xtrem_async_helper_1.asyncArray)(this._nodes).sort(this.compareSortValues.bind(this)).toArray()}async update(t,e){const a=await this.sourceState.getJoinValues(this.property),i={};if(!this.property.isTransientInput&&this.sourceState.status!==node_state_1.StateStatus.constructed)await this.forEach(t=>{i[t.$.state.interningKeyValues[0]]=t.$.state});if(e.length>0&&null!=e[0]._action)await this.partialUpdate(t,e,a,i);else await this.fullUpdate(t,e,a,i)}isValid(){return true}}exports.MutableCollection=MutableCollection;
//# sourceMappingURL=mutable-collection.js.map