import { Node, NodeCreateData } from '../ts-api';
import { BaseCollection } from './base-collection';
export declare class MutableCollection extends BaseCollection {
    get isVitalCollectionChild(): boolean;
    get isAssociationChild(): boolean;
    get hasSortValue(): boolean;
    reset(): Promise<void>;
    fill(array: NodeCreateData<Node>[]): Promise<void>;
    insert(i: number, data: NodeCreateData<Node>): Promise<void>;
    append(data: NodeCreateData<Node>): Promise<void>;
    delete(start: number, deleteCount?: number): Promise<void>;
    /**
     * Force the lazy-loading of the collection in the old.state of the sourceNode
     * This function is mainly invoked before an item is deleted from the collection (so that node.$.old.collection is valid)
     */
    private _forceLazyloadingForSourceOld;
    /**
     * Find the key of the oldState from the oldMap
     * @param dataWithKey
     * @param oldMap
     * @returns
     */
    private findOldTokenFromData;
    isValid(): boolean;
}
//# sourceMappingURL=mutable-collection.d.ts.map