/** @packageDocumentation @module runtime */
import { AnyValue, AsyncArray, AsyncReader } from '@sage/xtrem-async-helper';
import { AsyncResponse } from '@sage/xtrem-shared';
import { CollectionProperty } from '../properties';
import { Collection, Node, NodeCreateData, NodeQueryFilter, NodeQueryOptions, SqlWhereInterface } from '../ts-api';
export interface CollectionCreateOptions {
    nodes?: Node[];
}
export declare abstract class BaseCollection extends AsyncArray<Node> implements Collection<Node> {
    sourceNode: Node;
    readonly property: CollectionProperty;
    private nodesPromise;
    private getNodes;
    get joinValues(): AsyncResponse<NodeQueryFilter<Node>>;
    get name(): string;
    /**
     * Tries to prefetch the records of the collection.
     * @param forUpdate
     * @returns The records of the collection or undefined if the prefetching is not possible.
     */
    private prefetchRecords;
    private combineFilters;
    withReader<R extends AnyValue>(body: (reader: AsyncReader<Node>) => R): Promise<R>;
    join(sep?: string): Promise<string>;
    get fullName(): string;
    /**
     * indicates if the the collection's nodes are loaded
     */
    get isLoaded(): boolean;
    get length(): Promise<number>;
    reset(): Promise<void>;
    fill(array: NodeCreateData<Node>[]): Promise<void>;
    insert(i: number, data: NodeCreateData<Node>): Promise<void>;
    append(data: NodeCreateData<Node>): Promise<void>;
    delete(start: number, deleteCount?: number): Promise<void>;
    query(options: NodeQueryOptions): AsyncArray<Node>;
    where(condition?: (node: Node) => AsyncResponse<boolean>): SqlWhereInterface<Node>;
    takeOne(condition: (node: Node) => AsyncResponse<boolean>): Promise<Node | null>;
}
//# sourceMappingURL=base-collection.d.ts.map