/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MemoryCache=exports.logger=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),context_vault_1=require("../runtime/context-vault"),loggers_1=require("../runtime/loggers");exports.logger=loggers_1.loggers.globalCache;class MemoryCacheBucket{#e=0;constructor(e,t){this.value=e,this.ttlInSeconds=t.ttlInSeconds,this.recomputeExpirationTime(Date.now())}computeCost(){if(!this.#e)this.#e=JSON.stringify(this.value).length;return this.#e}isExpired(e){return e>this.expirationTime}recomputeExpirationTime(e){const t=this.expirationTime,o=this.ttlInSeconds,s=e+1e3*o;if(this.expirationTime=s,t)exports.logger.debug(()=>`Bucket - expiration date :  ${new Date(t).toISOString()} -> ${new Date(s).toISOString()} / ${o}`)}}var MemoryCacheTypeEnum;!function(e){e[e.context=0]="context",e[e.global=1]="global"}(MemoryCacheTypeEnum||(MemoryCacheTypeEnum={}));class MemoryCache{#t;#o;#s;constructor(e,t){this.#s=false,this._invalidatingTokenMap=(0,xtrem_shared_1.createDictionary)(),this._values=(0,xtrem_shared_1.createDictionary)(),this.#t=e,this.#o=t}getCounters(){const e={memoryCost:0,itemsCount:0};return Object.values(this._values).forEach(t=>{Object.values(t).forEach(t=>{e.memoryCost+=t.computeCost(),e.itemsCount+=1})}),e}fetchValue(e,t){const o=this._values[e];if(!o)return;const s=o[t];if(s){const o=Date.now();if(s.isExpired(o))exports.logger.debug(()=>`\t ${this.#o} memory cache ${e} EXPIRED: ${t}`);else return exports.logger.debug(()=>`\t ${this.#o} memory cache ${e} HIT: ${t}`),s.recomputeExpirationTime(o),s.value}else exports.logger.debug(()=>`\t ${this.#o} memory cache ${e} MISS: ${t}`);return}storeValue(e,t,o,s){o.invalidatingTokens?.forEach(o=>this.addInvalidatingToken(o,e,t));const r=new MemoryCacheBucket(o.value,s);if(this._values[e]=this._values[e]||{},this._values[e][t]=r,s.vault&&o.storedEncryptedProperties?.length)this.#s=true,s.vault.cacheValues(e,o.value,o.storedEncryptedProperties);exports.logger.verbose(()=>{let o=`${this.#o} memory cache ${e} store ${t}`;if(s)o+=`, will expire @ ${r.expirationTime} (ttl = ${r.ttlInSeconds} seconds)`;return o})}addInvalidatingToken(e,t,o){if(exports.logger.debug(()=>`${this.#o} memory cache add invalidating token: tenantId=${this.#t}, token=${e}, category=${t}, key=${o}`),!this._invalidatingTokenMap[e])this._invalidatingTokenMap[e]=[];this._invalidatingTokenMap[e].push({category:t,key:o})}invalidateCategory(e,t){const o=t.split(",");if(o.length>1)return void o.forEach(t=>this.invalidateCategory(e,t));if(t.endsWith("*")){const o=t.slice(0,-1);return exports.logger.debug(()=>`*** invalidateCategory categories: ${Object.keys(this._values)}`),void Object.keys(this._values).filter(e=>e.startsWith(o)).forEach(t=>this.invalidateCategory(e,t))}if(this.#s)context_vault_1.ContextVault.invalidateCache(t);this._values[t]=(0,xtrem_shared_1.createDictionary)();const s=e.application.globalCache.categoryTokens[t];if(!s)return;s.forEach(e=>{const o=this._invalidatingTokenMap[e];if(exports.logger.debug(()=>`${this.#o} memory cache invalidating token entries:  tenantId=${this.#t}, category=${t}, token=${e}, entries=${JSON.stringify(o)}`),!o)return;o.forEach(e=>this.deleteKey(e.category,e.key)),delete this._invalidatingTokenMap[e]})}deleteKey(e,t){const o=this._values[e];if(o&&o[t]){if(this.#s)context_vault_1.ContextVault.invalidateCache(e,t);delete o[t]}}purge(e,t){Object.keys(this._values).forEach(t=>{const o=this._values[t],s=Object.keys(o).filter(t=>o[t].isExpired(e));if(s.length)exports.logger.verbose(()=>`${this.#o} memory cache purge ${s.length} memory buckets`),s.forEach(e=>{const s=o[e].expirationTime;exports.logger.debug(()=>`\t-  ${this.#o} memory cache purge bucket ${e} / ${new Date(s).toISOString()}`),this.deleteKey(t,e)})});const o=[];if(Object.keys(this._values).forEach(e=>{const s=this._values[e],r=Object.keys(s).sort((e,t)=>{const keyValue=e=>s[e].expirationTime;return keyValue(e)-keyValue(t)});let i=0;r.forEach(e=>{if(i>t)o.push(e);else i+=s[e].computeCost()}),o.forEach(t=>{exports.logger.debug(()=>`\t-  ${this.#o} memory cache purge bucket ${t}`),this.deleteKey(e,t)})}),o.length)exports.logger.verbose(()=>{const e=this.getCounters();return`${this.#o} memory cache max cost exceeded (${e.memoryCost}/${t}), purge ${o.length} memory buckets`})}clear(){if(this.#s)for(const e of Object.keys(this._values))context_vault_1.ContextVault.invalidateCache(e);this._values=(0,xtrem_shared_1.createDictionary)()}showCounters(){return exports.logger.verbose(()=>{const e=this.getCounters();return`${this.#o} memory cache counters : tenant=${this.#t}, memory=(${Object.keys(this._values).length}, items/cost=${e.memoryCost})`})}}exports.MemoryCache=MemoryCache;
//# sourceMappingURL=memory-cache.js.map