/** @ignore */ /** */
import { AnyValue } from '@sage/xtrem-async-helper';
import { ProfilerCallback } from '@sage/xtrem-shared';
import { StringProperty } from '../properties';
import { Context } from '../runtime/context';
import { ContextVault } from '../runtime/context-vault';
import { GlobalCacheOptions } from './global-cache';
export declare const logger: import("@sage/xtrem-log/lib/logger").Logger;
declare enum MemoryCacheTypeEnum {
    context = 0,
    global = 1
}
export type MemoryCacheType = keyof typeof MemoryCacheTypeEnum;
export declare class MemoryCache {
    #private;
    private _invalidatingTokenMap;
    private _values;
    constructor(tenantId: string, type: MemoryCacheType);
    getCounters(): MemoryCacheCounters;
    fetchValue<T extends AnyValue>(category: string, key: string): T | undefined;
    storeValue<T extends AnyValue>(category: string, key: string, item: {
        value: T;
        invalidatingTokens?: string[];
        storedEncryptedProperties?: StringProperty[];
    }, options: GlobalCacheOptions<T> & {
        vault?: ContextVault;
    }): void;
    /**
     * Add a token to `this.#MemoryCache`.
     *
     * This is called after a query has been run, to associate the query's `{ category, key }` pair with the token
     * (the name of a table which was joined by the query).
     */
    private addInvalidatingToken;
    /**
     * Removes the cache entries for queries that joined one of the table names of a node factory (one of the tokens
     * of a category).
     *
     * This is called when we invalidate a node factory (a category) after records have been inserted/updated/deleted
     * in the factory's table (or in one of its tables if the factory is part of an inheritance tree).
     *
     * This is also called when we receive an `invalidateCategoryCache` broadcast event from another container.
     * In this case, the database change was done in a different container but we can use the same logic
     * to update our cache.
     */
    invalidateCategory(context: Context, category: string): void;
    purge(now: number, maxCost: number): void;
    showCounters(): ProfilerCallback;
}
export {};
//# sourceMappingURL=memory-cache.d.ts.map