/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.GlobalCache=exports.logger=void 0;const xtrem_config_1=require("@sage/xtrem-config"),concurrency_utils_1=require("../concurrency-utils"),runtime_1=require("../runtime"),loggers_1=require("../runtime/loggers"),memory_cache_1=require("./memory-cache");exports.logger=loggers_1.loggers.globalCache;class Funnel{static{this._funnelsByKey={}}#e;#t=0;#n;constructor(e){this.#e=(0,runtime_1.monitoredFunnel)("globalCache",1),this.#n=e,Funnel._funnelsByKey[e]=this}async invoke(e){this.#t+=1;try{return await this.#e(e)}finally{if(this.#t-=1,0===this.#t)delete Funnel._funnelsByKey[this.#n]}}static getFunnel(e){return Funnel._funnelsByKey[e]||new Funnel(e)}}const DEFAULT_MAX_COST=5e5,emptyCounters={queryCount:0,contextHitCount:0,memoryHitCount:0,missCount:0,memoryCost:0,itemsCount:0};class GlobalCache{constructor(){this._memoryCachesByTenant={},this._counters={...emptyCounters},this.categoryTokens={},(0,concurrency_utils_1.safeSetInterval)(this._purgeMemoryBuckets.bind(this),3e4),(0,concurrency_utils_1.safeSetInterval)(this._showCounters.bind(this),18e5)}getCounters(){return Object.values(this._memoryCachesByTenant).reduce((e,t)=>{const n=t.getCounters();return e.itemsCount+=n.itemsCount,e.memoryCost+=n.memoryCost,e},{...this._counters})}clearAll(){exports.logger.warn("*** CACHE CLEAR ALL ***"),this._memoryCachesByTenant={},this._counters={...emptyCounters}}_showCounters(){if(!exports.logger.isActive("verbose"))return;Object.values(this._memoryCachesByTenant).forEach(e=>e.showCounters())}_purgeMemoryBuckets(){const e=Date.now(),t=Object.values(this._memoryCachesByTenant),n=(xtrem_config_1.ConfigManager.current.settings?.globalCache?.maxCost||DEFAULT_MAX_COST)/(t.length||1);try{t.forEach(t=>t.purge(e,n))}catch(e){exports.logger.error(`Error purging memory cache: ${e.message}`)}}setCategoryTokens(e,t){this.categoryTokens[e]=t}static getTenantId(e,t){return t.startsWith("$SHARED_NODE.")?"*":e.tenantId||"*"}static getTenantIdList(e,t){return t.map(t=>this.getTenantId(e,t))}async invalidateCategory(e,t,n={}){const r=GlobalCache.getTenantIdList(e,t.split(","));for(const o of r){exports.logger.debug(()=>`*** invalidateCategory tenantId:${o} category:${t} skipNotify:${n.skipNotify}`);const r=this._memoryCachesByTenant[o];if(r)r.invalidateCategory(e,t)}if(!e.managedExternal)if(!n.skipNotify)await e.notifyInvalidateCategory(t)}invalidateAllCategories(e,t={}){const n=[];if(null!=e.tenantId)n.push("*");if(t.includeShared)n.push("$SHARED_NODE.*");return this.invalidateCategory(e,n.join(","),t)}_storeInMemoryCache(e,t,n,r,o,s){if(!s.cacheInMemory)return;let a=this._memoryCachesByTenant[t];if(!a)a=new memory_cache_1.MemoryCache(t,"global"),this._memoryCachesByTenant[t]=a;a.storeValue(n,r,o,{...s,vault:e.vault})}getValueInMemory(e,t,n){const r=this._memoryCachesByTenant[e];if(!r)return;return r.fetchValue(t,n)}async getValue(e,t){const{category:n,key:r}=t,o=GlobalCache.getTenantId(e,n),s=!t.isolateInContext;this._counters.queryCount+=1,exports.logger.debug(()=>`Global cache read value for key = ${o}.${n}.${r}`);const a=e.cache.fetchValue(n,r);if(null!=a)return this._counters.contextHitCount+=1,a;if(t.cacheInMemory){const s=this.getValueInMemory(o,n,r);if(void 0!==s){if(this._counters.memoryHitCount+=1,null!=s)e.cache.storeValue(n,r,{value:s},t);return s}}const u=`${o}.${n}.${r}`;return Funnel.getFunnel(u).invoke(async()=>{const a=e.cache.fetchValue(n,r);if(null!=a)return this._counters.contextHitCount+=1,a;if(t.cacheInMemory){const s=this.getValueInMemory(o,n,r);if(void 0!==s){if(this._counters.memoryHitCount+=1,null!=s)e.cache.storeValue(n,r,{value:s},t);return s}}if(this._counters.missCount+=1,t.getValue){exports.logger.debug(()=>`\tCompute value for missing key (${u})`);const a=await t.getValue();if(null!==a.value)if(e.cache.storeValue(n,r,a,t),s)this._storeInMemoryCache(e,o,n,r,a,t);return a.value}throw new Error(`Could not compute value for key ${u}`)})}}exports.GlobalCache=GlobalCache;
//# sourceMappingURL=global-cache.js.map