/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.S3Manager=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),child_process_1=require("child_process"),fs=require("fs"),os=require("os"),fsp=require("path"),readline=require("readline"),semver=require("semver"),stream=require("stream"),application_1=require("../application"),archive_1=require("../archive"),loggers_1=require("../runtime/loggers"),database_sql_context_1=require("../sql/sql-context/database-sql-context"),schema_sql_context_1=require("../sql/sql-context/schema-sql-context"),check_recompute_values_hash_1=require("../utils/check-recompute-values-hash"),progress_transform_1=require("./progress-transform"),restore_envelop_1=require("./restore-envelop"),s3_helper_1=require("./s3-helper"),logger=loggers_1.loggers.dump,s3Configurations={forSqlFiles:{bucket:"xtrem-developers-utility",folder:"backupsForSqlFiles",getFullFolder(e){return`${this.folder}/${e.name}`}},clusterCuBackup:{bucket:"xtrem-developers-utility",folder:"dev-eu-cls-cu-backups-result/sdmo",s3Key:"xtrem-cls-cu-sdmo-current.gz"},sdmo_cu:{bucket:"xtrem-developers-utility",folder:"dev-eu-cls-cu-backups-result/sdmo",s3Key:"xtrem-cls-cu-sdmo-current.gz"},clusterCiBackup:{bucket:"xtrem-developers-utility",folder:"dev-eu-ci-v2-backups-result/sdmo",s3Key:"xtrem-ci-v2-sdmo-latestWorking.gz"},sdmo:{bucket:"xtrem-developers-utility",folder:"dev-eu-ci-v2-backups-result/sdmo",s3Key:"xtrem-ci-v2-sdmo-latestWorking.gz"},clusterDevRelease:{bucket:"xtrem-developers-utility",folder:"dev-eu-cls-release-backups-result/sdmo",s3Key:"xtrem-cls-release-sdmo-latest.gz"},clusterQaRelease:{bucket:"xtrem-developers-utility",folder:"qa-na-cls-release-backups-result/sdmo",s3Key:"xtrem-cls-release-sdmo-latest.gz"},glossary:{bucket:"xtrem-developers-utility",folder:"dev-eu-ci-v2-backups-result/glossary",s3Key:"xtrem-ci-v2-glossary-latestWorking.gz"},showcase:{bucket:"xtrem-developers-utility",folder:"dev-eu-ci-v2-backups-result/showcase",s3Key:"xtrem-ci-v2-showcase-latestWorking.gz"},shopfloor:{bucket:"xtrem-developers-utility",folder:"dev-eu-ci-v2-backups-result/shopfloor",s3Key:"xtrem-ci-v2-shopfloor-latestWorking.gz"},shopfloor_cu:{bucket:"xtrem-developers-utility",folder:"dev-eu-cls-cu-backups-result/shopfloor",s3Key:"xtrem-cls-cu-shopfloor-current.gz"},x3_connector:{bucket:"xtrem-developers-utility",folder:"dev-eu-ci-v2-backups-result/x3-connector",s3Key:"xtrem-ci-v2-x3-connector-latestWorking.gz"}},createRole=["DO $$$$","BEGIN","CREATE ROLE xtrem WITH NOLOGIN;","EXCEPTION WHEN DUPLICATE_OBJECT THEN","RAISE NOTICE 'not creating role xtrem -- it already exists';","END","$$$$;","",""].join("\n");class S3Manager{static{this._postgreSqlTools={isCi:false,version:"",image:""}}constructor(e){this.application=e,this.tempFolder=os.tmpdir()}async dumpSchemaToS3Bucket(){const e=this.application,r=await e.packageManager.getCurrentVersion(e.mainPackage)||"0.0.0";logger.info(`Upload database schema ${e.name}@${r} to s3://${s3Configurations.forSqlFiles.bucket}`);const{tempFolder:s}=this,t=`${e.shortName}@${r}.zip`,o=S3Manager.normalizeApplicationName(t),a=fsp.join(s,o);await S3Manager.dumpSchemaToFile(s,o,e.schemaName);try{const e=await this.uploadDumpToS3(s,o,t);return logger.info(()=>`The db dump was uploaded to ${e}`),e}finally{if(logger.verbose(()=>`Delete temp file ${a}`),fs.existsSync(o))fs.unlinkSync(a)}}_getFullS3Folder(e){return null==e.getFullFolder?e.folder:e.getFullFolder(this.application)}async _resolveVersionToRestoreForSqlFiles(e){const r=s3Configurations.forSqlFiles;if((""===e||"latest"===e)&&!r.s3Key){const r=await this.getAvailableVersions();if(0===r.length)await this._raiseErrorVersionNotFoundForSqlFile(e,r);const s=r[0];return logger.info(`'latest' was resolved as ${s}`),s}return e}async _raiseErrorVersionNotFoundForSqlFile(e,r){const s=this.application,t=r||await this.getAvailableVersions();let o=`No version '${e||"latest"}' could be found for application ${s.name}@${s.version}`;const a="\n\t- ";if(r?.length)o=`${o}, compatible versions are:${a}${t.join(a)}`;throw new Error(o)}async restoreSchemaFromS3Bucket(e,r="forSqlFiles",s={checkSingleSchema:false,skipValuesHash:false}){await(new database_sql_context_1.DatabaseSqlContext).createDatabaseIfNotExists();const t=new restore_envelop_1.RestoreEnvelop(this,e,r);await t.restore((e,r)=>S3Manager.runRestoreProcess(e,r));let{mayBeAnonymizedData:o}=t;if(o&&s.skipValuesHash)logger.warn("Recomputation of _valuesHash was skipped"),o=false;if(o){const e=this.application,r=await(0,check_recompute_values_hash_1.getTenantIdList)(e);await(0,xtrem_async_helper_1.asyncArray)(r).forEach(async r=>{await(0,check_recompute_values_hash_1.checkAndSyncValuesHash)(e,r,logger)})}await this._listSchemas(s.checkSingleSchema),logger.info(t.successMessage)}async _listSchemas(e){const r=this.application,s=(await r.createContextForDdl(e=>e.executeSql("select nspname name from pg_catalog.pg_namespace",[]))).map(e=>e.name).filter(e=>{if(e.startsWith("pg_"))return false;if("information_schema"===e)return false;if("public"===e)return false;return true});if(logger.info(`Schemas in the database: ${s.join(", ")}`),e&&1!==s.length)throw new Error(`Expected a single schema, found ${s.length}`)}uploadDumpToS3(e,r,s){return this._uploadLocalFileToS3(s3Configurations.forSqlFiles,fsp.join(e,r),s)}_uploadLocalFileToS3(e,r,s){const t={bucketName:e.bucket,folder:this._getFullS3Folder(e),key:s};return logger.verbose(()=>`Upload ${r} to ${s3_helper_1.S3Helper.buildS3Uri(t)}`),s3_helper_1.S3Helper.upload(r,t)}_isBackupForSqlFile(e){return e.startsWith(`${this.application.shortName}@`)}async getAvailableVersions(){const e=this.application,r=semver.major(e.mainPackage.packageJson.version);return(await this._listS3BackupsForSqlFile(s3Configurations.forSqlFiles.bucket)).map(e=>S3Manager._getVersionFromS3Key(e)).filter(e=>semver.major(e)===r).sort(semver.compare).reverse()}static _getVersionFromS3Key(e){const r=e.lastIndexOf("@"),s=e.lastIndexOf(".");return e.substring(r+1,s)}async _listS3BackupsForSqlFile(e){const r=this.application,s=s3Configurations.forSqlFiles,t=this._getFullS3Folder(s);logger.verbose(()=>`Looking for versions compatible with ${r.name}@${r.version} from s3://${e}/${t}`);const o=await s3_helper_1.S3Helper.listObjects({bucketName:e,folder:t,key:""});if(!o)return[];return o.map(e=>{if(null==e.key)return null;if(!e.key.startsWith(`${t}/`))return null;const r=e.key.substring(t.length+1);if(!this._isBackupForSqlFile(r))return null;return r}).filter(e=>e)}async getS3Info(e,r){const s=this.application,t=s3Configurations[e];if(!t)throw new Error(`Invalid configuration: ${e}`);let o;if("forSqlFiles"===e)o=await this._resolveVersionToRestoreForSqlFiles(r);else o=r;logger.info(`[${s.schemaName}] restore ${s.name}@${o} from s3://${t.bucket}/${t.folder}`);const a=t.s3Key||`${s.shortName}@${o}.zip`;if(!await s3_helper_1.S3Helper.objectExists({bucketName:t.bucket,folder:this._getFullS3Folder(t),key:a})){const e=await this.getAvailableVersions();await this._raiseErrorVersionNotFoundForSqlFile(o,e)}return{bucketName:t.bucket,folder:this._getFullS3Folder(t),key:a}}static _tailLogLine(e){if(e.endsWith("\n"))return e.substring(0,e.length-1);return e}static async _pipeStreamWithTransformations(e){const formatSize=e=>{if(e>=1048576)return`${(e/1048576).toFixed(2)} MB`;if(e>=1024)return`${(e/1024).toFixed(2)} KB`;return`${e} bytes`};await new Promise((r,s)=>{const t=readline.createInterface({input:e.inData,crlfDelay:1/0});let o=true,a=0,i=0,n="",l=false;const handleError=r=>{logger.error(`Transformation error: ${r.message}`),logger.info(`Processed ${i} lines.\nLast line read: ${n}`),l=true,e.outStream.destroy(),s(r)};if(t.on("error",handleError),e.outStream.on("error",handleError),e.inErr)e.inErr.on("data",e=>{const r=e.toString();logger.error(`ERR ${S3Manager._tailLogLine(r)}`)}),e.inErr.on("error",handleError);t.on("line",r=>{if(n=r,e.mappings.forEach(({reg:e,val:r})=>{n=n.replace(e,r)}),o=e.outStream.write(`${n}\n`),!o)t.pause();i++,a=Math.max(a,n.length),logger.debug(()=>`\t${S3Manager._tailLogLine(r)}`)}),e.outStream.on("drain",()=>{t.resume()}),t.on("close",()=>{e.outStream.end(),logger.info(`Transformation finished processing ${i} lines.\nMax line length encountered: ${formatSize(a)}`)}),e.outStream.on("finish",()=>{if(!l)r()}),e.inMain.on("close",r=>{if(![0,e.expectedExitCode].includes(r))handleError(new Error(`Exited with code ${r}`))})})}static _pgClientToolCommand(e,r,s){const t=xtrem_config_1.ConfigManager.current,o=this._postgreSqlTools;let a=[];if(!o.version){o.isCi=!!t.env?.isCI;const e=/^psql\s+\(\w+\)\s+(\d+\.\d+)/,r=">=16.1",s=`Please, install a version ${r}.\non Ubuntu systems you can do it with:\nsudo apt update\nsudo apt install postgresql-client`;if(a=["psql","--version"],o.isCi){const r=(0,child_process_1.spawnSync)("docker",["exec","-i","xtrem_postgres","psql","--version"],{encoding:"utf-8"});if(null!=r.error)throw new Error(`Cannot get image version of xtrem_postgres. ${s}`);o.version=e.exec(r.stdout)?.[1]??"",o.image=`postgres:${o.version}-alpine`,logger.info(`Use PostgreSQL client tools version ${o.version} from image ${o.image}`),a=["docker","run","-i","--rm",o.image,...a]}const i=(0,child_process_1.spawnSync)(a[0],a.slice(1),{encoding:"utf-8"});if(null!=i.error)throw new Error(`Cannot get PostgreSQL client tools version. ${s}`);o.version=e.exec(i.stdout)?.[1]??"";const n=semver.coerce(o.version);if(null==n)throw new Error(`Cannot get PostgreSQL client tools version. The version ${i.stdout} does not have the expected format. ${s}`);if(!semver.satisfies(n,r))throw new Error(`PostgreSQL client tools version ${n} does not satisfies the expected version ${r}. ${s}`);this._postgreSqlTools=o}if(!o.version)throw new Error("PostgreSQL client tools version could not be determined");o.image||=`postgres:${o.version}-alpine`;const i=os.tmpdir();if(a=[e,...r],o.isCi)a=["docker","run","-i","--rm","-v",`${i}:/tmp`,"-e",`PGPASSWORD=${s?.env?.PGPASSWORD}`,o.image,e,...r.map(e=>e.replace(i,"/tmp").replace("localhost","172.17.0.1").replace("127.0.0.1","172.17.0.1"))];return logger.info(()=>`Run command: ${a.join(" ").replace(/PGPASSWORD=[^ ]+/g,"PGPASSWORD=****")}`),(0,child_process_1.spawn)(a[0],a.slice(1),{...s,stdio:["pipe","pipe","pipe"]})}static async dumpSchemaToFile(e,r,s){const t=r.endsWith(".zip"),o=t?"sql.dump":r,a=fsp.join(e,o),i=xtrem_config_1.ConfigManager.current.storage?.sql;if(null==i)throw new Error("SQL configuration is missing");logger.verbose(()=>`Dump ${i.database}.${s} to ${a}`);const n=["--format=p",`--host=${i.hostname}`,`--dbname=${i.database}`,`--schema=${s}`,`--username=${i.user}`,"--no-password"],l=this._pgClientToolCommand("pg_dump",n,{env:{...process.env,PGPASSWORD:i.password},cwd:e});await S3Manager._pipeStreamWithTransformations({inData:l.stdout,inErr:l.stderr,inMain:l,outStream:fs.createWriteStream(a),mappings:[{reg:new RegExp(` SCHEMA ${s}`,"g"),val:" SCHEMA [SCHEMA_NAME]"},{reg:new RegExp(`${s}\\.`,"g"),val:"[SCHEMA_NAME]."},{reg:new RegExp(` TO ${i.user};`,"g"),val:" TO [USER_NAME];"},{reg:/ALTER DEFAULT PRIVILEGES FOR ROLE xtrem/,val:`${createRole}ALTER DEFAULT PRIVILEGES FOR ROLE xtrem`}],expectedExitCode:0});const c=fsp.join(e,r);if(t)if(logger.verbose(()=>`Zip ${a} to ${c}`),await archive_1.Compress.zipFile(a,o,c,{zlib:{level:9}}),logger.debug(()=>`Deleting temp file ${a}`),fs.existsSync(a))fs.unlinkSync(a)}static _getMappingsForDumpFiles(e,r,s){const t=[{reg:/\[SCHEMA_NAME\]/g,val:e},{reg:/\[USER_NAME\]/g,val:s.user}],o=fs.openSync(r,"r");try{const e=1e3,r=Buffer.alloc(e),a=fs.readSync(o,r);if(a!==e)return logger.warn(`\t- could only get ${a} out of ${e} first chars of the SQL file`),t;const i=r.toString().match(/^-- Name: \S+; Type: SCHEMA; Schema: \S+; Owner: (\S+)$/m);if(i&&s.user!==i[1])logger.info(`\t- will remap user '${i[1]}' to '${s.user}'`),t.push({reg:new RegExp(` OWNER TO ${i[1]};$`,"gm"),val:` OWNER TO ${s.user};`})}catch(e){logger.warn(`\t- encountered error ${e.message} while building mappings to apply to the SQL file`)}finally{fs.closeSync(o)}return t}static runRestoreProcess(e,r){if(e.isZip)return S3Manager.runRestoreFromMappedFile(e,r);if(r instanceof stream.Readable){const{s3ConfigurationType:s,localFullFilename:t}=e;return e.s3Manager.restoreSchemaFromBackupStream(t,r,"clusterCiBackup"===s||"sdmo"===s||null!=s3Configurations.sdmo.s3Key&&t.includes(s3Configurations.sdmo.s3Key))}throw new Error("No filename or stream provided to restore the schema")}static runRestoreFromMappedFile(e,r){if(r instanceof stream.Readable)throw new Error("Readable stream are not supported yet");return this._restoreFromMappedFile(r,e.s3Manager.application.schemaName)}static async _restoreFromMappedFile(e,r){const s=xtrem_config_1.ConfigManager.current.storage?.sql;if(null==s)throw new Error("SQL configuration is missing");logger.verbose(()=>`Restore ${s.database}.${r} from mapped file ${e}`),logger.info(()=>`[${r}] restore schema from ${e}`);const t=[`--host=${s.hostname}`,`--dbname=${s.database}`,`--username=${s.sysUser}`,`--file=${e}`,"--single-transaction"];if(void 0!==s.port)t.push("--port"),t.push(`${s.port}`);const o=this._pgClientToolCommand("psql",t,{env:{...process.env,PGPASSWORD:s.sysPassword},cwd:fsp.dirname(e)});await S3Manager._childProcessHandler(o,{hackForSdmo:false,rejectOnStderr:true})}static async restoreFromDumpFile(e,r,s){const t=xtrem_config_1.ConfigManager.current.storage?.sql;if(null==t)throw new Error("SQL configuration is missing");logger.verbose(()=>`Restore ${t.database}.${s} from ${r}`);const o=fsp.join(e,"sql.mapped.dump");logger.info(()=>`[${s}] transform ${r} to ${o}`);const a=S3Manager._getMappingsForDumpFiles(s,r,t),i=fs.createReadStream(r);if(await S3Manager._pipeStreamWithTransformations({inData:i,inMain:i,outStream:fs.createWriteStream(o),mappings:a,expectedExitCode:void 0}),logger.info(()=>`Delete original dump file ${r} after transformation`),fs.existsSync(r))fs.unlinkSync(r);if(await S3Manager._restoreFromMappedFile(o,s),fs.existsSync(o))fs.unlinkSync(o)}async restoreSchemaFromBackupStream(e,r,s=false){const{tempFolder:t}=this,o=xtrem_config_1.ConfigManager.current.storage?.sql;if(null==o)throw new Error("SQL configuration is missing");const a=fs.createWriteStream(e);await new Promise((s,t)=>{stream.pipeline(r,new progress_transform_1.ProgressTransform,a,r=>{if(r)t(r);else s(e)})});const{application:i}=this,n=await this._processTableOfContentsForRestoration(e);if(logger.info(()=>`The dump concerns the following schemas : ${n.schemas}`),!n.schemas.includes(i.schemaName))logger.warn(()=>`Your configuration is using the schema ${i.schemaName} which will not be restored by this backup`);if(i.schemaName!==application_1.ApplicationManager.getDefaultServiceSchemaName())switch(n.schemas.length){case 0:logger.warn(()=>"The dump does not contain any data/metadata for any schema");break;case 1:if(n.schemas[0]!==i.schemaName)logger.warn(()=>`The dump will be restored to the schema '${n.schemas[0]}' (forced schema '${i.schemaName}' will be ignored)`);break;default:if(!n.schemas.includes(i.schemaName))logger.warn(()=>`The dump concerns many schemas but none of them matches the schema ${i.schemaName}`)}await this._dropSchemasBeforeRestoration(n.schemas);const l=["-L",n.filename,"--host",o.hostname,"--username",o.sysUser??"","--dbname",o.database??"",e,"--no-owner","--no-privileges"];if(void 0!==o.port)l.push("--port"),l.push(`${o.port}`);const c=S3Manager._pgClientToolCommand("pg_restore",l,{env:{...process.env,PGPASSWORD:o.sysPassword},cwd:t});if(await S3Manager._childProcessHandler(c,{hackForSdmo:s}),o.user!==o.sysUser)await(0,xtrem_async_helper_1.asyncArray)(n.schemas).forEach(async e=>{await(new database_sql_context_1.DatabaseSqlContext).setUserDefaultPrivileges(e),await(new database_sql_context_1.DatabaseSqlContext).setUserPrivileges(e)})}async _processTableOfContentsForRestoration(e){const generateTempFilename=async()=>{const e=await fs.promises.mkdtemp(`${this.tempFolder}${fsp.sep}`);return fsp.join(e,"pg_restore_without_extenstion_comments.list")},r={filename:await generateTempFilename(),schemas:[]};await S3Manager._childProcessHandler(S3Manager._pgClientToolCommand("pg_restore",["--version"]),{hackForSdmo:false,stdoutCallback:e=>{logger.info(`pg_restore.version=${e}`)}});let s="";await S3Manager._childProcessHandler(S3Manager._pgClientToolCommand("pg_restore",["-l",e]),{hackForSdmo:false,stdoutCallback:e=>{s=`${s}${e}`}}),s=s.replace(/(\d+; \d+ \d+ COMMENT - EXTENSION)/g,";$1");const t=[...s.matchAll(/\d+; \d+ \d+ SCHEMA - (\w+)/g)];if(t)r.schemas=t.map(e=>e[1]).filter(e=>"public"!==e);return fs.writeFileSync(r.filename,s),r}dropApplicationSchema(){return this._dropSchemasBeforeRestoration([this.application.schemaName])}_dropSchemasBeforeRestoration(e){const{application:r}=this;return r.createContextForDdl(r=>(0,xtrem_async_helper_1.asyncArray)(e).forEach(e=>(logger.info(()=>`[${e}] Drop schema (if exists)`),new schema_sql_context_1.SchemaSqlContext(r.application).dropSchema(e))),{description:()=>`Drop schemas ${e.join()}`})}static async _childProcessHandler(e,r){let s=0;await new Promise((t,o)=>{e.stdout.on("data",e=>{if(r.stdoutCallback)r.stdoutCallback(e.toString());else logger.debug(()=>e.toString())}),e.stderr.on("data",t=>{const i=t.toString();if(r.hackForSdmo){if(["plv8","errors ignored on restore: 1",'relation "lock_monitor" already exists'].some(e=>i.includes(e)))return}if(i.includes("ERROR:"))s+=1;if(logger.error(i),i&&r.rejectOnStderr)logger.error(`Got error from child process: ${e.pid}`),a?.destroy(),o(new Error(i))}),e.on("close",i=>{if(0===i&&0===s)return void t();if(r.hackForSdmo&&1===i)return void t();const n=`process ${e.pid} exited with code ${i}, ${s} errors`;logger.error(n),a?.destroy(),o(new Error(n))});const a=r.streams?.[0];if(e.on("error",e=>{console.error("Error child:",e),a?.destroy(),o(e)}),a){const r=e.stdin;if(!r)return a?.destroy(),void o(new Error("Child process stdin is not available"));a.pipe(new progress_transform_1.ProgressTransform("Processed")).pipe(r).on("end",()=>{r.end(),t()}).on("error",e=>{if("EPIPE"===e.code)console.error("EPIPE error:",e),a.destroy(),r.end(),t();else if(a?.destroy(),o(e),logger.error(e.message),e)process.exit(1)})}})}static normalizeApplicationName(e){return e.replace(/@/g,"").replace(/[/,\\]/g,"-")}}exports.S3Manager=S3Manager;
//# sourceMappingURL=s3-manager.js.map