/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.S3Helper=exports.toMegabytesString=exports.toMegabytes=void 0;const fs=require("fs"),file_utils_1=require("../file-utils"),loggers_1=require("../runtime/loggers"),s3_bucket_1=require("./s3-bucket"),logger=loggers_1.loggers.core,toMegabytes=e=>e/1024/1024;exports.toMegabytes=toMegabytes;const toMegabytesString=e=>`${(0,exports.toMegabytes)(e).toFixed(2)} MB`;exports.toMegabytesString=toMegabytesString;class S3Helper{static _checkS3Bucket(e,t){if(!e)return;if(e.bucketName!==t.bucketName)throw new Error(`The provided S3 bucket is incompatible with the bucket ${t.bucketName}`)}static async upload(e,t,r){const s=S3Helper.buildS3Uri(t),o=r||new s3_bucket_1.S3Bucket(t.bucketName);if(S3Helper._checkS3Bucket(r,t),!await(0,file_utils_1.fileExists)(e))throw new Error(`File ${e} does not exist`);const c=fs.createReadStream(e);return await o.putObject({Key:`${t.folder}/${t.key}`,ContentType:"application/string",Body:c}),s}static async download(e,t,r){const s=r||new s3_bucket_1.S3Bucket(e.bucketName);S3Helper._checkS3Bucket(r,e),logger.info(`S3 - Downloading s3://${e.bucketName}/${e.folder}/${e.key}`);try{await s.writeObjectToFile({Key:`${e.folder}/${e.key}`},t)}catch(t){throw new Error(`Could not download s3://${e.bucketName}/${e.folder}/${e.key}, reason was ${t.message}`)}}static downloadStream(e,t){const r=t||new s3_bucket_1.S3Bucket(e.bucketName);return S3Helper._checkS3Bucket(t,e),r.getObjectStream({Key:`${e.folder}/${e.key}`})}static getS3Bucket(e){return new s3_bucket_1.S3Bucket(e)}static parseS3Uri(e){if(!e.startsWith("s3://"))throw new Error(`Invalid S3 URI: ${e}`);const t=e.substring(5).split("/");if(t.length<3)throw new Error(`Incomplete S3 URI: ${e}`);return{bucketName:t[0],folder:t.slice(1,t.length-1).join("/"),key:t[t.length-1]}}static buildS3Uri(e){return`s3://${e.bucketName}/${e.folder}/${e.key}`}static async objectExists(e){const t=new s3_bucket_1.S3Bucket(e.bucketName),r={Prefix:`${e.folder}/${e.key}`,MaxKeys:1};return((await t.listObjectsV2(r)).KeyCount||0)>0}static async _listObjectsV2(e,t,r){const s=await t.listObjectsV2(r);if(!s.Contents)return[];const o=s.Contents.map(e=>({key:e.Key,lastModified:e.LastModified,eTag:e.ETag,size:e.Size,storageClass:e.StorageClass}));return!s.IsTruncated?o:o.concat(await S3Helper._listObjectsV2(e,t,{...r,ContinuationToken:s.NextContinuationToken}))}static listObjects(e){return S3Helper._listObjectsV2(e,new s3_bucket_1.S3Bucket(e.bucketName),{Prefix:`${e.folder}/${e.key}`})}}exports.S3Helper=S3Helper;
//# sourceMappingURL=s3-helper.js.map