/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.S3Bucket=void 0;const client_s3_1=require("@aws-sdk/client-s3"),client_sts_1=require("@aws-sdk/client-sts"),credential_provider_node_1=require("@aws-sdk/credential-provider-node"),xtrem_config_1=require("@sage/xtrem-config"),fs=require("fs"),stream_1=require("stream");class S3Bucket{constructor(e){this.bucketName=e;const t=xtrem_config_1.ConfigManager.current.s3&&xtrem_config_1.ConfigManager.current.s3[e],s={region:S3Bucket.getRegion(e)};if(t)if(t.accessKey||t.secret)s.credentials={accessKeyId:t.accessKey,secretAccessKey:t.secret};if(null==s.credentials){const e=(0,credential_provider_node_1.defaultProvider)({roleAssumerWithWebIdentity:(0,client_sts_1.getDefaultRoleAssumerWithWebIdentity)()});s.credentials=e}this._s3Client=new client_s3_1.S3Client(s)}get s3Client(){return this._s3Client}static getRegion(e){let t=process.env.AWS_REGION||"eu-west-1";if(e){const s=xtrem_config_1.ConfigManager.current.s3&&xtrem_config_1.ConfigManager.current.s3[e];if(s?.region)t=s?.region}return t}_addBucket(e){return{Bucket:this.bucketName,...e}}async _tryWait(e){try{return await e}catch(e){switch(e.Code){case"InvalidAccessKeyId":case"SignatureDoesNotMatch":throw new Error(`${e.Code} [${e.message}] Please set s3.${this.bucketName}.accessKey/s3.${this.bucketName}.secret in xtrem-config.yml or set the environment variables AWS_ACCESS_KEY_ID/AWS_SECRET_ACCESS_KEY.`)}throw new Error(`${e.Code??""} [${e.message}]`)}}listObjectsV2(e){return this._tryWait(this._s3Client.send(new client_s3_1.ListObjectsV2Command(this._addBucket(e))))}putObject(e){return this._tryWait(this._s3Client.send(new client_s3_1.PutObjectCommand(this._addBucket(e))))}async _writeObjectToStream(e,t){const s=new client_s3_1.GetObjectCommand(this._addBucket(e)),r=await this._tryWait(this._s3Client.send(s));if(!r.Body)throw new Error(`Invalid S3 object ${this.bucketName}/${e.Key}`);await new Promise((s,i)=>{const n=r.Body;if(n instanceof stream_1.Readable)n.on("close",()=>{s(void 0)}),n.on("error",e=>{i(e)}),n.pipe(t);else i(new Error(`Invalid stream type received for object ${this.bucketName}/${e.Key}`))})}async writeObjectToFile(e,t){const s=fs.createWriteStream(t);await this._writeObjectToStream(this._addBucket(e),s)}async getObjectStream(e){const t=new client_s3_1.GetObjectCommand(this._addBucket(e)),s=await this._tryWait(this._s3Client.send(t));if(!s.Body)throw new Error(`Invalid S3 object ${this.bucketName}/${e.Key}`);const r=s.Body;if(r instanceof stream_1.Readable)return r;throw new Error(`Invalid stream type received for object ${this.bucketName}/${e.Key}`)}}exports.S3Bucket=S3Bucket;
//# sourceMappingURL=s3-bucket.js.map