/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.RestoreEnvelop=void 0;const xtrem_config_1=require("@sage/xtrem-config"),fs=require("node:fs"),os=require("node:os"),fsp=require("node:path"),unzipper=require("unzipper"),loggers_1=require("../runtime/loggers"),maping_transform_1=require("./maping-transform"),s3_helper_1=require("./s3-helper"),s3_manager_1=require("./s3-manager"),logger=loggers_1.loggers.dump;class RestoreEnvelop{#e;#r;#i=false;constructor(e,r,i){this.s3Manager=e,this.versionOrS3Uri=r,this.s3ConfigurationType=i}get mayBeAnonymizedData(){return this.#i}get sourceS3Info(){return this.#r}get isFile(){return this.versionOrS3Uri.startsWith("file://")}get localFullFilename(){return this.#e}get isZip(){return this.#e.endsWith(".zip")}get isDump(){return this.#e.endsWith(".gz")}get isS3(){return this.versionOrS3Uri.startsWith("s3://")}async init(){if(this.versionOrS3Uri.startsWith("file://"))return this.#e=this.versionOrS3Uri.substring(7),void(this.#i=true);if(this.versionOrS3Uri.startsWith("s3://"))this.#r=s3_helper_1.S3Helper.parseS3Uri(this.versionOrS3Uri),this.#i=true;else this.#r=await this.s3Manager.getS3Info(this.s3ConfigurationType,this.versionOrS3Uri);const e=os.tmpdir(),r=s3_manager_1.S3Manager.normalizeApplicationName(this.#r.key);this.#e=fsp.join(e,r)}async restore(e){await this.init();try{if(this.#r?.key.endsWith(".zip"))return void await this.restoreFromS3Zip(e);if(this.isFile&&this.#e.endsWith(".zip"))return void await this.restoreFromFileZip(e);if(!this.#e.endsWith(".gz"))throw new Error(`Invalid dump file type: ${this.#e}`);let r;if(this.isFile)r=fs.createReadStream(this.#e);else{if(!this.#r)throw new Error("No S3 info found");r=await this.downloadDumpFileFromS3ObjectInfo(this.#r)}if(!r)throw new Error(`No source stream found for ${this.#e}`);await e(this,r)}finally{if(!this.isFile&&fs.existsSync(this.#e))logger.info(`Delete temp file ${this.#e}`),fs.unlinkSync(this.#e)}}downloadDumpFileFromS3ObjectInfo(e){return logger.info(()=>`Download ${s3_helper_1.S3Helper.buildS3Uri(e)} to ${this.#e}`),s3_helper_1.S3Helper.downloadStream(e)}async restoreFromS3Zip(e){const r=this.#r;if(!r)throw new Error("No S3 info found");const i=s3_helper_1.S3Helper.getS3Bucket(r.bucketName).s3Client,t=await unzipper.Open.s3_v3(i,{Bucket:r.bucketName,Key:`${r.folder}/${r.key}`});await this.restoreFromZipEntry(t,e)}async restoreFromFileZip(e){const r=await unzipper.Open.file(this.#e);await this.restoreFromZipEntry(r,e)}async restoreFromZipEntry(e,r){const i=xtrem_config_1.ConfigManager.current.storage?.sql;if(!i)throw new Error("No SQL configuration found");const t=e.files.filter(e=>/\.(sql|dump)$/.test(e.path))[0];if(!t){const r="No .sql or .dump file found in the zip";if(e.files.find(e=>e.path.endsWith(".zip")))throw new Error(`${r}, but a .zip file was found. Nested zip files are not supported, please extract it first.`);if(e.files.filter(e=>e.path.endsWith(".csv")).length>0)throw new Error(`${r}, but .csv files were found. This looks like a tenant export, please use the 'xtrem tenant --import <base64-description>' command instead.`);throw new Error(r)}const s=t.stream();return await this.s3Manager.dropApplicationSchema(),this.restoreFromMappedStream(t.path,s,new maping_transform_1.MappingTransform(this.s3Manager.application.schemaName,i.user,t.uncompressedSize),r)}async restoreFromMappedStream(e,r,i,t){const{schemaName:s}=i,o=xtrem_config_1.ConfigManager.current.storage?.sql;if(null==o)throw new Error("SQL configuration is missing");const n=fsp.join(os.tmpdir(),fsp.basename(e).replace(/\.(zip|sql)$/,".dump")),l=fs.createWriteStream(n);return logger.info(()=>`[${s}] generating mapped file to ${n}`),await new Promise((e,t)=>{r.pipe(i).pipe(l).on("finish",()=>{logger.info(()=>`[${s}] mapped file saved to ${n}`),e()}).on("error",e=>{logger.info(()=>`[${s}] Failed to save mapped file to ${n}`),t(e)})}),t(this,n)}get successMessage(){if(this.#r)return`Successfully restored ${this.#r.key}`;if(this.#e)return`Successfully restored from local file ${this.#e}`;return""}}exports.RestoreEnvelop=RestoreEnvelop;
//# sourceMappingURL=restore-envelop.js.map