import * as stream from 'node:stream';
import { S3ObjectInfo } from './s3-helper';
import { S3ConfigurationType, S3Manager } from './s3-manager';
type RunRestoreCallback = (envelop: RestoreEnvelop, filenameOrStream: string | stream.Readable) => Promise<void>;
export declare class RestoreEnvelop {
    #private;
    readonly s3Manager: S3Manager;
    readonly versionOrS3Uri: string;
    readonly s3ConfigurationType: S3ConfigurationType;
    constructor(s3Manager: S3Manager, versionOrS3Uri: string, s3ConfigurationType: S3ConfigurationType);
    get mayBeAnonymizedData(): boolean;
    get sourceS3Info(): S3ObjectInfo | undefined;
    get isFile(): boolean;
    get localFullFilename(): string;
    get isZip(): boolean;
    get isDump(): boolean;
    get isS3(): boolean;
    private init;
    restore(runRestore: RunRestoreCallback): Promise<void>;
    /**
     * Download a file from a S3ObjectInfo.
     * The function will return the filename of the written file (short filename, without the folder)
     *
     * @param sourceS3Info the information of the file to download
     */
    private downloadDumpFileFromS3ObjectInfo;
    private restoreFromS3Zip;
    private restoreFromFileZip;
    private restoreFromZipEntry;
    private restoreFromMappedStream;
    get successMessage(): string;
}
export {};
//# sourceMappingURL=restore-envelop.d.ts.map