/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MappingTransform=void 0;const stream=require("stream"),loggers_1=require("../runtime/loggers"),s3_helper_1=require("./s3-helper"),logger=loggers_1.loggers.dump;class MappingTransform extends stream.Transform{static{this.highWaterMark=10485760}#e;constructor(e,t,s){super({highWaterMark:MappingTransform.highWaterMark,objectMode:true}),this.schemaName=e,this.user=t,this.expectedSize=s,this.#e=Buffer.alloc(0),this.done=false,this.size=0,this.totalSize=0,this.mappings=[{reg:/\[SCHEMA_NAME\]/g,val:e},{reg:/\[USER_NAME\]/g,val:t}],this.logSize=null!=s?s/10:10*MappingTransform.highWaterMark}_transform(e,t,s){if(this.size+=e.length,this.totalSize+=e.length,this.size>this.logSize)this.size=0,logger.info(`Transformed: ${(0,s3_helper_1.toMegabytesString)(this.totalSize)} out of ${(0,s3_helper_1.toMegabytesString)(this.expectedSize??0)} (rss ${(0,s3_helper_1.toMegabytesString)(process.memoryUsage().rss)})`);const i=e.lastIndexOf("\n");let r=this.#e;if(-1===i)return this.#e=Buffer.concat([this.#e,e]),void s();const a=e.subarray(0,i+1);if(this.#e=e.subarray(i+1),r=Buffer.concat([r,a]),!this.done){const e=r.toString("utf8").split("\n");for(const t of e){const e=t.match(/^-- Name: \S+; Type: SCHEMA; Schema: \S+; Owner: (\S+)$/m);if(e&&this.user!==e[1]){logger.info(`\t- will remap user '${e[1]}' to '${this.user}'`),this.mappings.push({reg:new RegExp(` OWNER TO ${e[1]};$`,"gm"),val:` OWNER TO ${this.user};`}),this.done=true;break}}if(!this.done)return void this.pushWithBackPressureGuard(r,s)}let n=r.toString("utf8");this.mappings.forEach(({reg:e,val:t})=>{n=n.replace(e,t)}),this.pushWithBackPressureGuard(n,s)}pushWithBackPressureGuard(e,t){if(!this.push(e))this.once("drain",t);else t()}_flush(e){let t=this.#e.toString("utf8");if(this.#e=Buffer.alloc(0),this.mappings.forEach(({reg:e,val:s})=>{t=t.replace(e,s)}),!this.push(t))this.once("drain",e);else e();if(logger.info(`Final transformed: ${(0,s3_helper_1.toMegabytesString)(this.totalSize)}`),null!=this.expectedSize&&this.totalSize!==this.expectedSize)logger.warn(`The expected size (${this.expectedSize}) does not match the actual size (${this.totalSize})`)}}exports.MappingTransform=MappingTransform;
//# sourceMappingURL=maping-transform.js.map