/**
 * Helper to decompress zip archives (only zip archives are supported by extract-zip).
 * Uses 'extract-zip' npm module https://www.npmjs.com/package/extract-zip
 */
export declare abstract class Decompress {
    /**
     * Decompress a zip archive to a local folder (this folder must already exist) and returns the RELATIVE path
     * of the extracted files (relative to the provided targetPath)
     * @param archiveFilename the path of the zip archive to extract
     * @param targetPath the local folder where the extracted files should be written (this folder must exist)
     */
    static decompressZipToFolder(archiveFilename: string, targetPath: string): Promise<string[]>;
}
//# sourceMappingURL=decompress.d.ts.map