/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.unhandledErrorMonitor=exports.UnhandledErrorMonitor=void 0;const util_1=require("util"),loggers_1=require("../runtime/loggers"),logger=loggers_1.loggers.application;class UnhandledErrorMonitor{constructor(){this._started=false,this._threshold=10,this._interval=3600,this._unhandledRejection=0,this._uncaughtException=0}unhandledRejection(t,e){this._unhandledRejection+=1,logger.error(`Unhandled Rejection: ${t} at Promise ${(0,util_1.inspect)(e)}`)}uncaughtException(t){if(this._uncaughtException+=1,logger.error(`Uncaught Exception thrown: ${t.stack}`),this._uncaughtException>this._threshold)logger.error(`Uncaught Exception reatched threshold of ${this._threshold} in ${this._interval} seconds, exiting...`),process.exit(1)}start(t,e){if(this._started)return;this._started=true,this._threshold=e||this._threshold,global.setInterval(()=>{if(0!==this._uncaughtException||0!==this._unhandledRejection)logger.info(`resetting uncaught exception counters: uncaughtException=${this._uncaughtException}, unhandledRejection=${this._unhandledRejection}`);this._uncaughtException=0,this._unhandledRejection=0},1e3*(t||this._interval))}}exports.UnhandledErrorMonitor=UnhandledErrorMonitor,exports.unhandledErrorMonitor=new UnhandledErrorMonitor,process.on("unhandledRejection",(t,e)=>exports.unhandledErrorMonitor.unhandledRejection(t,e)).on("uncaughtException",t=>exports.unhandledErrorMonitor.uncaughtException(t));
//# sourceMappingURL=unhandled-error-monitor.js.map