/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.UiBroadcaster=exports.UiBroadcasterBucket=void 0;const xtrem_metrics_1=require("@sage/xtrem-metrics"),crypto=require("crypto"),loggers_1=require("../runtime/loggers"),application_1=require("./application"),logger=loggers_1.loggers.application;class UiBroadcasterBucket{#e={};get pendingMessages(){return this.#e}addMessage(e,t,s){const r=`${e} / ${t} / ${s}`,a=crypto.createHash("sha256").update(r).digest("base64");this.#e[a]={tenantId:e,category:t,payload:s}}addBucket(e){Object.keys(e.pendingMessages).forEach(t=>{const s=e.pendingMessages[t];this.#e[t]=s})}clear(){if(0===Object.keys(this.#e).length)return;this.#e={}}}exports.UiBroadcasterBucket=UiBroadcasterBucket;class UiBroadcaster{#t;#s=new UiBroadcasterBucket;#r=null;constructor(e,t){this.application=e,this.options=t,this.#t=this.options?.timeout??5e3,this.startBackgroundProcessing()}get pendingMessages(){return this.#s.pendingMessages}broadcast(e,t,s){if(!e)throw new Error("Cannot broadcast message: No valid tenantId found.");if(!t)throw new Error("Cannot broadcast message: No valid category found.");if(this.#s.addMessage(e,t,s),!this.#r)this.startBackgroundProcessing()}addBucket(e){if(!e)throw new Error("Cannot add bucket: No valid bucket found.");if(this.#s.addBucket(e),!this.#r)this.startBackgroundProcessing()}startBackgroundProcessing(){this.#r=setInterval(()=>{if(!this.#r)return;const e=this.pendingMessages;if(0===Object.keys(e).length)return;this.resetPendingMessages(),(async()=>{const t=Object.values(e).map(async e=>(this.recordBroadcastMetric(e),this.application.notificationManager.broadcast(e)));await Promise.all(t),application_1.Application.emitter.emit("uiBroadcastCompleted")})().catch(e=>{const t=e instanceof Error?e.message:String(e);logger.error(`Error in UI broadcaster: ${t}`),application_1.Application.emitter.emit("uiBroadcastError",t)})},this.#t)}resetPendingMessages(){this.#s.clear()}recordBroadcastMetric(e){try{const t=e.payload.split("/")[0]||"unknown";xtrem_metrics_1.CustomMetrics.broadcast.withMetricsSync({tenantId:e.tenantId,category:e.category,nodeName:t},()=>{})}catch(e){logger.warn(`Failed to record broadcast metric: ${e.message}`)}}close(){if(this.#r)clearInterval(this.#r),this.#r=null;this.resetPendingMessages()}}exports.UiBroadcaster=UiBroadcaster;
//# sourceMappingURL=ui-broadcaster.js.map