import { Application } from './application';
/** *
 * For CRUD notifications
 *  - category NOTIFICATION_CATEGORY_NODE_MODIFIED is the only category at the moment
 *  - payload should be <node_name>/<created or updated or deleted>
 *
 * For custom notifications
 *  - category NOTIFICATION_CATEGORY_NODE_MODIFIED is the only category at the moment
 *  - payload must be agreed between UI and server but keep a similar <node_name>/<custom_data>
 */
export interface UiBroadcastMessage {
    tenantId: string;
    category: string;
    payload: string;
}
/**
 * A broadcaster to send UI messages to all the users.
 * It collects messages in a bucket and broadcasts them periodically.
 * The messages are collected during a transaction and then broadcasted after the transaction is committed.
 * The broadcasting is done periodically, so that we can avoid sending too many messages at once
 * and it avoids having duplicate messages.
 */
export declare class UiBroadcaster {
    #private;
    private readonly application;
    private readonly options?;
    constructor(application: Application, options?: {
        timeout?: number;
    } | undefined);
    private get pendingMessages();
    broadcast(tenantId: string, category: string, payload: string): void;
    addBucket(bucket: UiBroadcasterBucket): void;
    /**
     * Broadcast pending messages to all the users
     */
    private startBackgroundProcessing;
    private resetPendingMessages;
    private recordBroadcastMetric;
}
//# sourceMappingURL=ui-broadcaster.d.ts.map