import { Context } from '../runtime';
export type ServiceOptionStatus = 'workInProgress' | 'experimental' | 'released';
export interface ServiceOptionArg {
    readonly __filename: string;
    name?: string;
    code?: string;
    status: ServiceOptionStatus;
    description?: string;
    isSubscribable?: boolean;
    isHidden: boolean;
    activates?: () => ServiceOption[];
    isActiveByDefault?: true;
    onEnabled?: (context: Context) => Promise<void>;
    onDisabled?: (context: Context) => Promise<void>;
    notifies?: true;
}
export declare class ServiceOption {
    #private;
    readonly name: string;
    readonly code?: string;
    readonly status: ServiceOptionStatus;
    readonly description?: string;
    readonly isSubscribable: boolean;
    isHidden: boolean;
    readonly activates?: () => ServiceOption[];
    readonly isActiveByDefault: boolean;
    readonly notifies?: true;
    onEnabled?: (context: Context) => Promise<void>;
    onDisabled?: (context: Context) => Promise<void>;
    constructor(arg: ServiceOptionArg);
    setPackageName(name: string): void;
    get packageName(): string;
    getLocalizedTitleKey(): string;
}
//# sourceMappingURL=service-option.d.ts.map