/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ServiceOptionManager=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_toposort_1=require("@sage/xtrem-toposort"),_=require("lodash"),runtime_1=require("../runtime");class ServiceOptionManager{#e={};#t;constructor(e){this.application=e,e.getPackages().forEach(e=>this.createServiceOptions(e)),Object.freeze(this.#e)}createServiceOptions(e){Object.keys(e.serviceOptions).forEach(t=>{const i=e.serviceOptions[t];if(this.#e[i.name])throw new xtrem_shared_1.SystemError(`Service option ${i.name} is declared in more than one package. ${this.#e[i.name].packageName} and ${e.name}.`);i.setPackageName(e.name),this.#e[i.name]=i})}sortServiceOptions(e){const t=e.map(e=>({name:e.name,dependsOn:e.activates?.().map(e=>e.name)}));return(0,xtrem_toposort_1.topoSort)(t).reverse().map(e=>this.application.serviceOptionsByName[e.name])}get sortedServiceOptions(){if(!this.#t)this.#t=this.sortServiceOptions(Object.values(this.application.serviceOptionsByName)),Object.freeze(this.#t);return Object.freeze(this.#t),this.#t}get serviceOptionsByName(){return this.#e}static isServiceOptionStatusEnabled(e){if("released"===runtime_1.Context.getConfigurationValue("serviceOptionsLevel"))return"released"===e;if("experimental"===runtime_1.Context.getConfigurationValue("serviceOptionsLevel"))return"workInProgress"!==e;return true}async activateServiceOption(e,t,i={}){if(i[t.name])return;if(i[t.name]=true,!await e.isServiceOptionEnabled(t))await this.setServiceOptionActiveState(e,t,true),e.setServiceOptionsEnabledFlag(t,true);const r=t.activates?.();if(r?.length)await(0,xtrem_async_helper_1.asyncArray)(r).forEach(async t=>{await this.activateServiceOption(e,t,i)})}static getActivatingActiveOptions(e,t){const i=Object.values(e.application.serviceOptionsByName).filter(e=>e.activates?.().some(e=>e===t));return(0,xtrem_async_helper_1.asyncArray)(i).filter(t=>e.isServiceOptionEnabled(t)).toArray()}async deactivateServiceOption(e,t){const i=await ServiceOptionManager.getActivatingActiveOptions(e,t);if(t.isHidden&&i.length>0)return false;const r=await e.isServiceOptionEnabled(t);if(r)await this.setServiceOptionActiveState(e,t,false),e.setServiceOptionsEnabledFlag(t,false);if(t.isHidden){if(t.activates)await(0,xtrem_async_helper_1.asyncArray)(t.activates?.()).forEach(async t=>{await this.deactivateServiceOption(e,t)})}else if(i.length>0)await(0,xtrem_async_helper_1.asyncArray)(i).forEach(async t=>{await this.deactivateServiceOption(e,t)});return r}async activateServiceOptions(e,t){const i={},r=await e.activeServiceOptions;return await(0,xtrem_async_helper_1.asyncArray)(t).forEach(async t=>{await this.activateServiceOption(e,t,i)}),_.difference(await e.activeServiceOptions,r)}async deactivateServiceOptions(e,t){e.clearServiceOptionEnabledFlags();const i=this.sortedServiceOptions.filter(e=>t.includes(e));if(await(0,xtrem_async_helper_1.asyncArray)(i).forEach(async t=>{await this.deactivateServiceOption(e,t)}),t.length===this.sortedServiceOptions.length)await(0,xtrem_async_helper_1.asyncArray)(t).forEach(async t=>{if(!await e.isServiceOptionEnabled(t))throw new xtrem_shared_1.LogicError(`deactivation of service options failed to deactivate ${t.name}`)})}async setServiceOptionActive(e,t,i){if(i)await this.activateServiceOptions(e,[t]);else await this.deactivateServiceOptions(e,[t])}createOrUpdateServiceOptions(e){return Promise.resolve()}deleteObsoleteServiceOptions(e){return Promise.resolve()}createOrUpgradeServiceOptionStates(e,t){return Promise.resolve()}}exports.ServiceOptionManager=ServiceOptionManager;
//# sourceMappingURL=service-option-manager.js.map