import { Context } from '../runtime/context';
import { ServiceOption } from './service-option';
import { ServiceOptionManager } from './service-option-manager';
/**
 * Service option manager stub used by xtrem-core unit tests.
 * It manages the service options and their active state in-memory, with a simple array of active service options.
 */
export declare class ServiceOptionManagerStub extends ServiceOptionManager {
    #private;
    isServiceOptionEnabled(_context: Context, serviceOption: ServiceOption): boolean;
    setServiceOptionActiveState(_context: Context, serviceOption: ServiceOption, isActive: boolean): Promise<void>;
    getEnabledServiceOptions(): Promise<ServiceOption[]>;
}
//# sourceMappingURL=service-option-manager-stub.d.ts.map