export interface PrintingManager {
    getPrintingAssignmentDialogUrl(): Promise<string | null>;
    getListPrintingWizardUrl(): Promise<string | null>;
    getRecordPrintingWizardUrl(): Promise<string | null>;
    hasRecordPrintingTemplates(page: string): Promise<boolean>;
    /**
     * Global async mutation name for printing a record list from the main list.
     * It must must have the following parameters:
     * - `filter`: The filter to apply to the record list, string.
     * - `nodeName`: The name of the node to print without vendor or package name such as `SalesOrder`, string.
     * - `parameters`: JSON string with the parameters to pass to print configuration extracted from the bulk action configuration page, string.
     * @param context
     */
    getRecordPrintingGlobalBulkMutationName(): Promise<string | null>;
    /**
     * Bulk action configuration URL for printing a record list from the main list.
     */
    getRecordListPrintingGlobalBulkActionConfigurationURL(): Promise<string | null>;
}
//# sourceMappingURL=printing-manager.d.ts.map