/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PackageValidationContext=exports.XtremAboutHelper=exports.Package=exports.getPackageQueueName=exports.getPackageName=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared");Object.defineProperty(exports,"getPackageName",{enumerable:true,get:function(){return xtrem_shared_1.getPackageName}}),Object.defineProperty(exports,"getPackageQueueName",{enumerable:true,get:function(){return xtrem_shared_1.getPackageQueueName}});const fs=require("fs"),lodash_1=require("lodash"),fsp=require("path"),decorator_utils_1=require("../decorators/decorator-utils"),loggers_1=require("../runtime/loggers"),types_1=require("../types"),logger=loggers_1.loggers.application;class Package{#e;#t;get dir(){return this._dir}#i;constructor(e,t,i){if(this.application=e,this.options=i,this._nodeExtensions=[],this.checkXtremAttribute=(e,t)=>{if(e&&e.xtrem&&"object"!=typeof e.xtrem)throw new Error(t())},!i.buildDir)throw new Error("A build directory must be provided to create an Application.");if(this.#e=t,this.buildDir=i.buildDir||"",i.api)this.api=i.api;this._dir=fsp.join(this.buildDir,"..")}async init(){const e=fsp.join(this.dir,"package.json"),t=this.#e?this.application.packageLoader.packageStubsByName[this.#e]:null;if(t)this._packageJson=t.content;else this._packageJson=require(e);const i=(0,xtrem_shared_1.getPackageName)(this._packageJson);if(i!==this.#e)this.#e=i;const s=this._packageJson.main||"build/index.js";if(this.options.api&&!this._packageJson.xtrem)this._packageJson.isMainUnitTest=true;else if(this._packageJson.xtrem&&(!this._packageJson.main||this._packageJson.xtrem.isMain&&!this._packageJson.xtrem.hasListeners)&&!this.isModule)this.api={};else if(this.isModule){const e=await(0,xtrem_async_helper_1.dynamicImport)(`${this.dir}/build/index.js`);this.api=(0,lodash_1.merge)({},e,this.options.api||{})}else{let e;try{e=require.resolve(this.dir)}catch{}const t=e?require(e):require.cache[s]?.exports??require(this.dir);this.api=(0,lodash_1.merge)({},t,this.options.api||{})}if(this.checkXtremAttribute(this._packageJson,()=>`xtrem property in ${e} should be an object`),!this._packageJson.xtrem&&!this._packageJson.isMainUnitTest)throw new Error(`${this._packageJson.name}: 'xtrem' key is missing in package.json`);if(this._packageJson.xtrem?.isMain&&!this._packageJson.xtrem?.appName);return this._packageJson.main=this._packageJson.main||s,this}static create(e,t,i){return new Package(e,t,i).init()}get isSealed(){return!!this._packageJson?.xtrem?.isSealed}get isHidden(){return!!this._packageJson?.xtrem?.isHidden||this.isAddOn}get isActiveByDefault(){return!this._packageJson?.xtrem?.isInactiveByDefault}get isReleased(){return!!this._packageJson?.xtrem?.isReleased}get sqlSchemaVersion(){return this._packageJson?.xtrem?.sqlSchemaVersion}get isMain(){return!!this._packageJson?.xtrem?.isMain}get isProxy(){return!!this._packageJson?.xtrem?.isProxy}get isService(){return!!this._packageJson?.xtrem?.isService}get isAddOn(){return!!this.options?.isAddOn}get isModule(){return"module"===this._packageJson.type}get hasListeners(){return!!this._packageJson?.xtrem?.hasListeners||this.isService||this.isAddOn||this.factories.some(e=>e.notificationListeners.length>0||e.messageListeners.length>0)}get queue(){if(this.#t)return this.#t;return this.#t=(0,xtrem_shared_1.getPackageQueueName)(this._packageJson),this.#t}get dependencies(){return this._packageJson.dependencies||{}}get directDependencies(){return Object.keys(this.dependencies).map(e=>this.application.packagesByName[e]).filter(e=>!!e)}get apiDependencies(){return(0,lodash_1.uniq)([...this.allDependencies.map(e=>`${e.name}-api`),...Object.keys(this.packageJson.devDependencies||{}).filter(e=>/@sage\/[a-z][a-z0-9-]*-api$/.test(e))])}get allDependencies(){if(this.#i)return this.#i;const e=this.application.packagesByName,t=new Set,scan=i=>{if(i.dependencies)Object.keys(i.dependencies).filter(i=>e[i]&&!t.has(e[i])).forEach(i=>{t.add(e[i]),scan(e[i])})};return scan(this),this.#i=[...t],this.#i}get packageJson(){if(!this._packageJson)throw new xtrem_shared_1.LogicError("lazy loading of package.json");return this._packageJson}get name(){return this.#e??(0,xtrem_shared_1.getPackageName)(this.packageJson)}get version(){return this.packageJson.version}get packageName(){return this.name}static getPackageJson(e){return require(fsp.join(e,"package.json"))}get xtremOptions(){return this.packageJson?.xtrem||{}}loadDecorators(){if(this.api)return;try{this.api=require(this.buildDir)}catch(e){logger.error(e.stack)}}get nodeExtensions(){return this._nodeExtensions}get activities(){return this.api.activities||{}}get activitiesExtensions(){return this.api.activityExtensions||{}}get serviceOptions(){return this.api.serviceOptions||{}}static decoratorFromFactory(e){return{...e.nodeDecorator,isVitalChild:e.isVitalChild,isVitalReferenceChild:e.isVitalReferenceChild,isVitalCollectionChild:e.isVitalCollectionChild,properties:e.properties,queries:e.queries,mutations:e.mutations,storage:e.storage,externalStorageManager:e.externalStorageManager,indexes:e.indexes,tableName:e.tableName,super:e.baseFactory?.name}}getNodeDecorators(){return this.factories.map(e=>Package.decoratorFromFactory(e))}getEnumDescriptors(){const e=this.api.enums;if(!e)return[];return Object.keys(e).filter(t=>!(e[t]instanceof types_1.DataType)).map(t=>{const i=e[t];return{name:t,values:Object.keys(i).filter(e=>!/^\d/.test(e)).reduce((e,t)=>({...e,[t]:i[t]}),{})}})}getEnumDataTypes(){if(this.enumDataTypes)return this.enumDataTypes;const e=this.api.enums;if(!e)return[];return this.enumDataTypes=Object.keys(e).filter(t=>e[t]instanceof types_1.EnumDataType).map(t=>{const i=e[t];return i.pack=this.name,i.name=t,i}),this.enumDataTypes}getExtensionDecorators(){const e=this.api.nodeExtensions;if(!e)return[];return Object.keys(e||{}).map(t=>{const i=e[t];if("function"==typeof i){const e=(0,decorator_utils_1.getDecorators)(i),t=this.application.getFactoryByConstructor(e.nodeExtension.extends()),s=(e.properties||[]).filter(e=>!e.isOverride).map(e=>t.findProperty(e.name));return{...e.nodeExtension,name:this.application.getFactoryByConstructor(e.nodeExtension.extends()).name,properties:s,queries:e.queries,mutations:e.mutations,notificationListeners:e.notificationListeners,messageListeners:e.messageListeners}}return logger.warn(`${t}: Skipping decorator detection`),null}).filter(e=>!!e)}getLocalizedTitleKey(){return`${this.name}/package__name`}}exports.Package=Package;class XtremAboutHelper{static load(e,t=""){const i="package.json";let s={name:t,version:"",author:"",description:"",license:"",buildStamp:""},a=e.mainPackage.dir;for(;;){const e=fsp.join(a,i),r=fsp.join(a,"pnpm-lock.yaml");if(fs.existsSync(e))try{const i=JSON.parse(fs.readFileSync(e,"utf8"));if(s=Object.keys(s).reduce((e,t)=>{let s=i[t]||"";if("object"==typeof s)s=s.name||"";return{...e,[t]:s||""}},{}),t&&i.name===s.name)break}catch{break}if(fs.existsSync(r))break;if(e===i)break;const n=fsp.join(a,"..");if(n===a)break;a=n}return s}}exports.XtremAboutHelper=XtremAboutHelper;class PackageValidationContext{constructor(){this.warnings=new Set}}exports.PackageValidationContext=PackageValidationContext;
//# sourceMappingURL=package.js.map