/** @packageDocumentation @module runtime */
import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
import { Dict, PackageJsonAbout, PackageJsonFile, RootMenuItem, SubMenuItem, XtremOptions, getPackageName, getPackageQueueName } from '@sage/xtrem-shared';
import { StaticThis } from '../decorators/decorator-utils';
import { NotificationTopic } from '../interop';
import { NodeFactory } from '../runtime';
import { ExternalEnumDecorator, ExternalNodeDecorator, ExternalNodeExtensionDecorator, Node } from '../ts-api';
import { Activity } from '../ts-api/activity';
import { ActivityExtension } from '../ts-api/activity-extension';
import { DataType, DataTypeOptions, EnumDataType } from '../types';
import { WorkflowStepInterface } from '../workflow/workflow-step-descriptor';
import { Application } from './application';
import { ServiceOption } from './service-option';
export interface PackageApi {
    nodes?: Dict<any>;
    nodeExtensions?: Dict<any>;
    enums?: Dict<any>;
    enumExtensions?: Dict<any>;
    serviceOptions?: Dict<ServiceOption>;
    menuItems?: Dict<SubMenuItem | RootMenuItem>;
    activities?: Dict<Activity>;
    activityExtensions?: Dict<ActivityExtension>;
    dataTypes?: Dict<DataType<AnyValue, DataTypeOptions>>;
    notificationTopics?: Dict<NotificationTopic>;
    workflowSteps?: Dict<WorkflowStepInterface>;
    startService?: (application: Application) => AsyncResponse<void>;
}
export interface PackageCreateOptions {
    buildDir?: string;
    api?: PackageApi;
    isAddOn?: boolean;
}
export { PackageJsonAbout, PackageJsonFile, XtremOptions, getPackageName, getPackageQueueName };
export declare class Package {
    #private;
    readonly application: Application;
    options: PackageCreateOptions;
    private buildDir;
    private _dir;
    get dir(): string;
    api: PackageApi;
    private _packageJson;
    factories: NodeFactory[];
    _nodeExtensions: StaticThis<Node>[];
    private constructor();
    private init;
    static create(application: Application, name: string | null, options: PackageCreateOptions): Promise<Package>;
    get isSealed(): boolean;
    /**
     * @disabled_internal
     * indicate if the package is hidden (technical) or not. Hidden packages cannot be deactivated
     */
    get isHidden(): boolean;
    /**
     * Indicate if the package should be active by default.
     */
    get isActiveByDefault(): boolean;
    /**
     * indicate if the package is released.
     */
    get isReleased(): boolean;
    /**
     * indicate if the package is released.
     */
    get sqlSchemaVersion(): string | undefined;
    /**
     * indicate if the package is a main package.
     */
    get isMain(): boolean;
    /**
     * indicate if the package is a proxy package.
     */
    get isProxy(): boolean;
    /**
     * Is the packages a service which handles SQS notifications and/or messages.
     * Only service packages have SQS queues.
     */
    get isService(): boolean;
    /**
     * Is the packages from a third party extension
     */
    get isAddOn(): boolean;
    /** Is the package an ESM module */
    get isModule(): boolean;
    /**
     * Indicates if the package can have listeners registered
     */
    get hasListeners(): boolean;
    get queue(): string;
    get dependencies(): Dict<string>;
    get directDependencies(): Package[];
    get apiDependencies(): string[];
    /** Returns a list of all the dependencies of the current package, and their dependencies, etc.
     * @param app: application object used to retrieve the full package list.
     */
    get allDependencies(): Package[];
    private checkXtremAttribute;
    get packageJson(): PackageJsonFile;
    get name(): string;
    get version(): string;
    get packageName(): string;
    static getPackageJson(dir: string): PackageJsonFile;
    get xtremOptions(): XtremOptions;
    /** Require the code of the Application and loads the application api attribute. */
    loadDecorators(): void;
    /**
     * Returns the list of nodeExtensions created by the package
     */
    get nodeExtensions(): StaticThis<Node>[];
    get activities(): Dict<Activity>;
    get activitiesExtensions(): Dict<ActivityExtension>;
    get serviceOptions(): Dict<ServiceOption>;
    static decoratorFromFactory(factory: NodeFactory): ExternalNodeDecorator;
    getNodeDecorators(): ExternalNodeDecorator[];
    getEnumDescriptors(): ExternalEnumDecorator[];
    private enumDataTypes;
    getEnumDataTypes(): EnumDataType[];
    getExtensionDecorators(): ExternalNodeExtensionDecorator[];
    getLocalizedTitleKey(): string;
}
export declare abstract class XtremAboutHelper {
}
export declare class PackageValidationContext {
    warnings: Set<string>;
}
//# sourceMappingURL=package.d.ts.map