import { Context } from '../runtime/context';
import { Application } from './application';
import { Package } from './package';
export interface CreateSchemaOptions {
    resetSchema?: boolean;
}
/**
 * Base class for service option managers
 */
export declare abstract class PackageManager {
    readonly application: Application;
    constructor(application: Application);
    findPackageByName(name: string): Package;
    getActivePackageNames(_context: Context): Promise<string[]>;
    abstract getCurrentVersion(_pack: Package, _context?: Context): Promise<string | undefined>;
    abstract validatePackageVersions(_context?: Context): Promise<void>;
    /**
     * Create the SQL schema (if needed) and all the tables
     */
    abstract createSqlSchemaAndTables(options?: CreateSchemaOptions): Promise<boolean>;
    /**
     * Make sure the schema for the application exists (and create it if needed)
     */
    abstract ensureSchemaExists(options?: CreateSchemaOptions): Promise<void>;
    createOrUpgradePackageAllocations(_context: Context, _activePackageNames?: string[]): Promise<void>;
}
//# sourceMappingURL=package-manager.d.ts.map