/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PackageLoader=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_shared_1=require("@sage/xtrem-shared"),fs=require("fs"),lodash_1=require("lodash"),fsp=require("path"),loggers_1=require("../runtime/loggers"),utils_1=require("../utils"),package_1=require("./package"),logger=loggers_1.loggers.nodeFactory,emptyPackageJson={name:"",version:"0.0.0",description:"",author:"",license:"",main:"",exports:{},type:"",isMainUnitTest:false,dependencies:{},devDependencies:{},peerDependencies:{}},packageScopesBlackList=["@aws-sdk","@aws-crypto","@swc","@types"];class PackageLoader{constructor(e){this.application=e,this.packagesByName=(0,xtrem_shared_1.createDictionary)(),this.packageStubsByName=(0,xtrem_shared_1.createDictionary)()}static getPackageStubFromPaths(e,a){try{const t=require.resolve(`${e}/package.json`,{paths:a}),s=fsp.dirname(t);return{name:e,dir:s,content:require(t)}}catch{const t=a.reduce((a,t)=>{if(a)return a;const s=PackageLoader.findUpPackageJson(t,e);if(!s)return a;const n=fsp.dirname(s),i=JSON.parse(fs.readFileSync(s,"utf-8"));return{name:e,dir:n,content:i}},null);if(null==t)throw new xtrem_shared_1.SystemError(`Could not find package.json for ${e} in paths: ${a}`);return t}}static findUpPackageJson(e,a){let t=e;for(;"/"!==t;){const e=fsp.join(t,"node_modules",a,"package.json");if(fs.existsSync(e))return e;t=fsp.join(t,"..")}return null}getPackageStubOfDependency(e,a){if(!this.packageStubsByName[e]){const t=this.application.dir,s=[a];if("production"!==process.env.NODE_ENV)(0,lodash_1.uniq)([t,a]).forEach(e=>{let a=fsp.join(e,"..","..");if("node_modules"!==fsp.basename(a))a=fsp.join(a,"node_modules");s.push(a)});const n=PackageLoader.getPackageStubFromPaths(e,s)??{name:e,dir:fsp.join(a,"node_modules",e),content:{...emptyPackageJson,name:e}};this.packageStubsByName[e]=n}return this.packageStubsByName[e]}isValidPackageName(e){let a=!this.application.nonPackageDependencies[e]&&"@"===e[0]&&!/(xtrem|etna)-ui$/.test(e)&&!/eslint/.test(e);if(a){const t=e.split("/")[0];a=!packageScopesBlackList.includes(t)}if(!a)return this.application.nonPackageDependencies[e]=true,false;return true}isPackageWithNodes(e,a){if(/^@sage\/test[\w\d-]+-app$/.test(e))return true;if(!this.isValidPackageName(e))return false;const t=this.packagesByName[e];if(t)return null!=t.packageJson.xtrem&&!t.packageJson.xtrem?.isFrontEndApp;if(!a)return this.application.nonPackageDependencies[e]=true,false;if(null!=a.xtrem&&!a.xtrem?.isFrontEndApp)return true;return this.application.nonPackageDependencies[e]=true,false}getDependencyBuildDir(e,a,t=[]){const s=this.packageStubsByName[e];if(s)return fsp.join(s.dir,"build");const n=(0,lodash_1.uniq)([a,fsp.join(a,"../.."),...t]),i=require.resolve(`${e}/package.json`,{paths:n});return fsp.join(fsp.dirname(i),"build")}static checkForNameCollisions(e){e.getEnumDescriptors().forEach(a=>{const t=a.name;if("enum"===e.application.nodeAndEnumNames[t])throw new xtrem_shared_1.SystemError(`Enum names cannot be duplicated. The enum name: ${t} was already used.`);else if("node"===e.application.nodeAndEnumNames[t])throw new xtrem_shared_1.SystemError(`Enum names cannot match node names. The enum name: ${t} was already used as a node name.`);e.application.nodeAndEnumNames[t]="enum"})}_verifyPackage(e){if(this.application.skipVerifications)return;const a=[e,...e.allDependencies].filter(e=>e.isService&&"@sage/xtrem-communication"!==e.name);if(a.length>1&&!e.isMain){const t=`${e.name}: invalid dependency graph: several services found: ${a.map(e=>e.name)}`;logger.warn(t)}if(!(xtrem_config_1.ConfigManager.current.storage?.managedExternal||utils_1.testPackageExclusions.includes(e.application.mainPackage.name))&&Object.keys(e.api.enumExtensions||{}).length>0)throw new xtrem_shared_1.LogicError(`${e.name}: enum extensions are only allowed on external applications.`);PackageLoader.checkForNameCollisions(e)}async createPackage(e,a){const t=await package_1.Package.create(this.application,e,a);return this.packagesByName[t.name]=t,this._verifyPackage(t),t.loadDecorators(),t}async scanPackage(e,a,t,s,n){const i=package_1.Package.getPackageJson(e);a.push(e);const r=Object.keys(i.dependencies||{}),c=Object.keys(i.peerDependencies||{}),o=(0,lodash_1.uniq)([...r,...c]);if("test"===this.application.applicationType&&null!=i.devDependencies&&Object.keys(i.devDependencies).includes("@sage/xtrem-routing"))o.push("@sage/xtrem-routing");if(0===o.length)return;await(0,xtrem_async_helper_1.asyncArray)(o).forEach(async i=>{if(t[i]||!this.isValidPackageName(i))return void(t[i]=true);const r=this.getPackageStubOfDependency(i,e),c=r.content;if(this.isPackageWithNodes(i,c)){if(await this.scanPackage(r.dir,a,t,s),!t[i]){const e=this.getDependencyBuildDir(i,this.application.dir,a);await this.createPackage(i,{...n,buildDir:e}),t[i]=true}}else t[i]=true})}async createAddOnPackages(e,a,t){if(this.application.addOnPackagePaths.length)await(0,xtrem_async_helper_1.asyncArray)(this.application.addOnPackagePaths).forEach(async s=>{const n=package_1.Package.getPackageJson(s),i=n.name;if(a[i])return;if(e.push(s),this.isPackageWithNodes(i,n)){const n=this.getDependencyBuildDir(s,this.application.dir,e);a[i]=true,await this.scanPackage(fsp.join(n,".."),e,a,t,{isAddOn:true}),await this.createPackage(i,{buildDir:n,isAddOn:true})}else a[i]=true})}createFactories(e){const a=Object.values(this.packagesByName);this.application.factoriesManager.createAllFactories(a,e),a.forEach(e=>{this.application.activityManager.createActivities(e)})}async createPackages(){const e={},a=new package_1.PackageValidationContext,t=[],s=performance.now();let n=logger.verbose(()=>"Loading packages");await this.scanPackage(this.application.dir,t,e,a),n.success(),this.packagesByName[this.application.mainPackage.name]=this.application.mainPackage,e[this.application.mainPackage.name]=true,n=logger.verbose(()=>"Loading add on packages"),await this.createAddOnPackages(t,e,a),n.success(),n=logger.verbose(()=>"Creating application factories"),this.createFactories(a),a.warnings.forEach(e=>logger.warn(`${e}`)),n.success(),this.application.factoriesManager.registerListeners(),Object.freeze(this.packagesByName),n=logger.verbose(()=>"Intializing localization resolver"),(0,xtrem_i18n_1.initializeLocalizationResolver)(Object.values(this.packagesByName),this.application.dir),n.success(),logger.info(`Loaded ${Object.keys(this.packagesByName).length} packages in ${Math.round(100*(performance.now()-s))/100}ms`)}}exports.PackageLoader=PackageLoader;
//# sourceMappingURL=package-loader.js.map