import { Application } from './application';
import { Package, PackageJsonFile } from './package';
export interface PackageStub {
    name: string;
    dir: string;
    content: PackageJsonFile;
}
export declare class PackageLoader {
    private application;
    readonly packagesByName: Record<string, Package>;
    readonly packageStubsByName: Record<string, PackageStub>;
    constructor(application: Application);
    private static getPackageStubFromPaths;
    private static findUpPackageJson;
    private getPackageStubOfDependency;
    /**
     * Check if a package name is valid for being loaded in the application
     * @param packageName
     * @returns
     */
    private isValidPackageName;
    /**
     * Returns whether a package contains some nodes and must be taken into account when compunting dependencies
     * @param packageName
     * @param dir
     */
    private isPackageWithNodes;
    private getDependencyBuildDir;
    /** Checks if there are any name collisions between enums and nodes */
    private static checkForNameCollisions;
    private _verifyPackage;
    private createPackage;
    /**
     * Scan package dependencies and load application packages
     * @param dir
     * @param knownPaths
     * @param processedPackages
     * @param packageValidationContext
     * @param options
     * @returns
     */
    private scanPackage;
    /**
     * Create add-on packages of application
     */
    private createAddOnPackages;
    private createFactories;
}
//# sourceMappingURL=package-loader.d.ts.map