import { InitialNotification, Notification, NotificationPayload, PromisifyProperties } from '@sage/xtrem-shared';
import { Context } from '../runtime';
import { UiBroadcastMessage } from './ui-broadcaster';
export interface NotificationManager {
    getUserNotifications(context: Context): Promise<Array<PromisifyProperties<Notification>>>;
    markRead(context: Context, _id: string): Promise<boolean>;
    markUnread(context: Context, _id: string): Promise<boolean>;
    markAllRead(context: Context): Promise<boolean>;
    delete(context: Context, _id: string): Promise<boolean>;
    dispatchUserNotification(context: Context, notification: InitialNotification): Promise<void>;
    dispatchAsyncMutationNotification(context: Context, payload: NotificationPayload): Promise<void>;
    broadcast(message: UiBroadcastMessage): Promise<void>;
}
export declare class NotificationManagerStub implements NotificationManager {
    getUserNotifications: () => Promise<Array<PromisifyProperties<Notification>>>;
    markRead: () => Promise<boolean>;
    markUnread: () => Promise<boolean>;
    markAllRead: () => Promise<boolean>;
    delete: () => Promise<boolean>;
    dispatchUserNotification: () => Promise<void>;
    dispatchAsyncMutationNotification: () => Promise<void>;
    broadcast: () => Promise<void>;
}
//# sourceMappingURL=notification-manager.d.ts.map