/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.NodeFactoriesManager=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),decorator_utils_1=require("../decorators/decorator-utils"),loggers_1=require("../runtime/loggers"),node_factory_1=require("../runtime/node-factory"),ts_api_1=require("../ts-api"),logger=loggers_1.loggers.nodeFactory;class NodeFactoriesManager{constructor(e){this.application=e,this._allFactoriesByName={},this._allFactoriesByTableName={}}getFactoryByConstructor(e){const o=e[decorator_utils_1.decoratorsSymbol],t=this._allFactoriesByName[o.node.name];if(!t)throw new Error(`${o.node.name}: no factory for Node constructor`);return t}checkForNameCollisions(e){if("enum"===this.application.nodeAndEnumNames[e.node.name])throw new xtrem_shared_1.SystemError(`Node names cannot match an Enum name. The node name: ${e.node.name} was already used as an enum name`);else if("node"===this.application.nodeAndEnumNames[e.node.name])throw new xtrem_shared_1.SystemError(`Node names cannot be duplicated. The node: ${e.node.name} was already used`);this.application.nodeAndEnumNames[e.node.name]="node"}getOrCreateNodeFactory(e,o){const t=o[decorator_utils_1.decoratorsSymbol];let r=this._allFactoriesByName[t.node.name];if(r)throw new xtrem_shared_1.LogicError(`Factory ${r.name} was already created by package ${r.package.name} but package ${e.name} tried to create it.`);return this.checkForNameCollisions(t),r=new node_factory_1.NodeFactory(e,o,t),this._allFactoriesByName[t.node.name]=r,r}getOrCreateNodeFactories(e,o){return(o||[]).filter(e=>e.prototype instanceof ts_api_1.Node&&!(e.prototype instanceof ts_api_1.NodeExtension)).map(o=>this.getOrCreateNodeFactory(e,o))}createNodeFactories(e,o){const t=this.getOrCreateNodeFactories(e,o);return e.factories=e.factories||[],e.factories.push(...t),t}createNonSubNodes(e){const o=Object.values(e.api.nodes||{}).filter(e=>{const o=e[decorator_utils_1.decoratorsSymbol];return o&&!o.superDecorators});return this.createNodeFactories(e,o)}createSubNodes(e){const getReadySubNodes=()=>Object.values(e.api.nodes||{}).filter(o=>{const t=o[decorator_utils_1.decoratorsSymbol];if(!t||!t.superDecorators)return false;const r=this._allFactoriesByName[t.node.name],a=this._allFactoriesByName[t.superDecorators.node.name];if(a&&a.package.isSealed&&"test"!==e.application.applicationType)throw new xtrem_shared_1.SystemError(`Wrongful attempt to extend node ${a.name} from a sealed package.`);return a&&!r});let o=getReadySubNodes();const t=[];for(;o.length;)t.push(...this.createNodeFactories(e,o)),o=getReadySubNodes();if(Object.values(e.api.nodes||{}).filter(e=>{const o=e[decorator_utils_1.decoratorsSymbol],t=o&&o.superDecorators&&!this._allFactoriesByName[o.superDecorators.node.name];if(t)logger.error(`Base class ${o.superDecorators.node.name} not found for ${o.node.name}`);return t}).length)throw new xtrem_shared_1.SystemError("Some subNodes were not created due to missing base nodes");return t}static setOperationsDefiningPackage(e){const setPackage=o=>{Object.values(o.queries||{}).forEach(o=>{o.definingPackage=e}),Object.values(o.mutations||{}).forEach(o=>{o.definingPackage=e}),Object.values(o.notificationListeners||{}).forEach(o=>{o.definingPackage=e}),Object.values(o.messageListeners||{}).forEach(o=>{o.definingPackage=e})};Object.values(e.api.nodes||{}).forEach(e=>{setPackage(e[decorator_utils_1.decoratorsSymbol]||{})}),Object.values(e.api.nodeExtensions||{}).forEach(e=>{setPackage(e[decorator_utils_1.decoratorsSymbol]||{})})}addExtensionDecorators(e){if(null==e.api.nodeExtensions||0===Object.keys(e.api.nodeExtensions).length)return;const o=Object.values(e.api.nodeExtensions),t=e.application.getAllFactories();o.forEach(o=>{const r=o[decorator_utils_1.decoratorsSymbol].nodeExtension.extends();e._nodeExtensions.push(o),o[decorator_utils_1.decoratorsSymbol].package=e;const getSubFactories=e=>t.filter(o=>{const t=o.decorators.superDecorators;if(!t)return false;return this._allFactoriesByName[t.node.name]===e});let a=[e.application.getFactoryByConstructor(r)];for(;a.length;){const e=[];a.forEach(t=>{t.addExtensionDecorator(o);const r=getSubFactories(t);e.push(...r)}),a=e}})}createAllFactories(e,o){e.forEach(e=>{this.createFactories(e)}),e.forEach(e=>{this.initFactories(e)}),this.completeFactories(o)}createFactories(e){logger.verbose(()=>`Creating factories for package ${e.name}`);const o=this.createNonSubNodes(e),t=this.createSubNodes(e);NodeFactoriesManager.setOperationsDefiningPackage(e),o.forEach(o=>o.createMainNodeProperties(e)),t.forEach(o=>o.createSuperNodeProperties(e)),t.forEach(o=>o.createSubNodeProperties(e))}initFactories(e){this.addExtensionDecorators(e);const o=Object.values(this._allFactoriesByName);e.factories.filter(e=>!!e.decorators.superDecorators).forEach(e=>e.mergeSubNodes()),o.forEach(o=>o.mergeExtensions(e)),o.forEach(e=>e.setSubFactories())}completeFactories(e){const o=Object.values(this._allFactoriesByName);o.filter(e=>e.decorators.superDecorators).forEach(e=>e.createSubNodeOverrides()),o.forEach(e=>{if("external"===e.storage&&e.externalStorageManager)e.externalStorageManager.factory=e}),o.forEach(o=>o.complement(e)),o.forEach(e=>e.verify()),o.forEach(e=>e.verifyJoins())}registerListeners(){Object.values(this._allFactoriesByName).forEach(e=>{const registerListener=o=>{o.register(e)};e.notificationListeners.forEach(registerListener),e.messageListeners.forEach(registerListener)})}getFactoryByName(e){const o=this.tryToGetFactoryByName(e);if(!o)throw new Error(`Factory '${e}' could not be found.`);return o}tryToGetFactoryByName(e){const o=this._allFactoriesByName[e];if(o)return o;const t=this.application.getAllFactories().find(o=>o.name===e);if(t)this._allFactoriesByName[e]=t;return t}getFactoryByTableName(e){const o=this._allFactoriesByTableName[e];if(o)return o;const t=this.application.getSqlPackageFactories().find(o=>o.tableName===e);if(!t)throw new Error(`Factory of table '${e}' could not be found.`);return this._allFactoriesByTableName[e]=t,t}}exports.NodeFactoriesManager=NodeFactoriesManager;
//# sourceMappingURL=node-factories-manager.js.map