/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.gracefulShutdown=void 0;const events_1=require("events"),loggers_1=require("../runtime/loggers");exports.gracefulShutdown=new events_1.EventEmitter;const logger=loggers_1.loggers.core;process.on("SIGTERM",()=>{exports.gracefulShutdown.emit("stop"),logger.info("Graceful shutdown has been initiated")}),exports.gracefulShutdown.on("stopped",()=>{logger.info(`Graceful shutdown complete - terminating process ${process.pid}`),setTimeout(()=>{process.exit(0)},5e3)});
//# sourceMappingURL=graceful-shutdown.js.map