import { Dashboard, DashboardItem, Dict } from '@sage/xtrem-shared';
import { Context } from '../runtime';
export interface DashboardManager {
    getSelectedDashboard(context: Context, group?: string): Promise<Dashboard | null>;
    setSelectedDashboard(context: Context, selectedDashboardId: string, group?: string): Promise<Dashboard>;
    updateDashboardItemSettings(context: Context, dashboardItemId: string, settings: object): Promise<void>;
    updateDashboardLayout(context: Context, dashboardItemId: string, layout: Dashboard): Promise<Dashboard>;
    addDashboardItem(context: Context, dashboardId: string, item: Partial<DashboardItem>): Promise<void>;
    getDashboardList(context: Context, group?: string): Promise<Dict<string>>;
    createDashboard(context: Context, group?: string): Promise<Dashboard>;
    cloneDashboard(context: Context, dashboardId: string): Promise<Dashboard>;
    deleteDashboard(context: Context, dashboardItemId: string): Promise<void>;
    getFactoryDashboardList(context: Context, group?: string): Promise<Dashboard[]>;
    getWidgetCategory(context: Context, widget: {
        _id: string;
        id: string;
    }): Promise<{
        key: string;
        title: string;
    }>;
    getWidgetCategories(context: Context): Promise<{
        key: string;
        title: string;
    }[]>;
    canEditDashboards(context: Context): Promise<boolean>;
}
export declare class DashboardManagerStub implements DashboardManager {
    getWidgetCategory: () => Promise<{
        key: string;
        title: string;
    }>;
    getWidgetCategories: () => Promise<[{
        key: string;
        title: string;
    }] | []>;
    getSelectedDashboard: () => Promise<Dashboard | null>;
    setSelectedDashboard: () => Promise<Dashboard>;
    updateDashboardItemSettings: () => Promise<void>;
    updateDashboardLayout: () => Promise<Dashboard>;
    addDashboardItem: () => Promise<void>;
    getDashboardList: () => Promise<Dict<string>>;
    createDashboard: () => Promise<Dashboard>;
    cloneDashboard: () => Promise<Dashboard>;
    deleteDashboard: () => Promise<void>;
    getFactoryDashboardList: () => Promise<Dashboard[]>;
    canEditDashboards: () => Promise<boolean>;
}
//# sourceMappingURL=dashboard-manager.d.ts.map