import type { Context } from '../runtime/context';
export interface ClientUserSettings {
    _id: string | number;
    title: Promise<string>;
    elementId: Promise<string>;
    description?: Promise<string>;
    content?: Promise<string>;
    isSelected?: Promise<boolean>;
}
export interface ClientSettings {
    title: string;
    description: string;
    content: string;
}
export interface ClientSettingsManager {
    getActiveClientSettingsForArtifact(context: Context, artifactId: string): Promise<ClientUserSettings[]>;
    getVariantsForElement(context: Context, artifactId: string, elementId: string): Promise<ClientUserSettings[]>;
    createClientSetting(context: Context, artifactId: string, elementId: string, content: string, title: string, description?: string): Promise<ClientUserSettings>;
    updateClientSetting(context: Context, _id: string, content: string, title: string, description?: string): Promise<ClientUserSettings>;
    selectClientSetting(context: Context, artifactId: string, elementId: string, _id: string): Promise<ClientUserSettings>;
    resetClientSettings(context: Context): Promise<boolean>;
    deleteClientSetting(context: Context, _id: string): Promise<boolean>;
    getCustomizationListPage(context: Context): string;
    getCustomizationEditPage(context: Context): string;
    unselectedClientSetting(context: Context, artifactId: string, elementId: string): Promise<void>;
}
export declare class ClientSettingsManagerStub implements ClientSettingsManager {
    unselectedClientSetting(): Promise<void>;
    getCustomizationListPage(): string;
    getCustomizationEditPage(): string;
    resetClientSettings(): Promise<boolean>;
    createClientSetting(): Promise<ClientUserSettings>;
    getActiveClientSettingsForArtifact(): Promise<ClientUserSettings[]>;
    getVariantsForElement(): Promise<ClientUserSettings[]>;
    updateClientSetting(): Promise<ClientUserSettings>;
    selectClientSetting(): Promise<ClientUserSettings>;
    deleteClientSetting(): Promise<boolean>;
}
//# sourceMappingURL=client-settings-manager.d.ts.map