import { integer } from '@sage/xtrem-shared';
import { Datetime } from '..';
import { Context } from '../runtime';
export interface ChatConversation {
    _createStamp: Datetime;
    id: string;
    title: string;
    messages: any[];
    inputTokensUsed: integer;
    outputTokensUsed: integer;
    cacheCreationTokensUsed: integer;
    cacheReadTokensUsed: integer;
    isFailed: boolean;
}
export interface ChatbotUsage {
    infer: {
        provider: string;
        modelId: string;
    };
    percent: number;
    blockedUntil?: Datetime;
}
export interface ChatbotAccess {
    isAllowed: boolean;
    reason?: string;
    usage?: ChatbotUsage;
}
export type ChatbotListExportTargetExtension = 'csv' | 'xlsx' | 'pdf' | 'json' | 'xml';
export interface ChatbotListExportParams {
    nodeName: string;
    outputFormat: ChatbotListExportTargetExtension;
    templateDefinition: {
        path: string;
        title: string;
    }[];
    filter?: string;
    orderBy?: string;
}
export interface TranscribeAudioChunkArgs {
    audioBuffer: Buffer;
    sampleRate: number;
    language: string;
    onProgress: (transcription: {
        text: string;
        isFinal: boolean;
    }) => void;
}
export interface ChatbotManager {
    isChatbotEnabled(context: Context): Promise<boolean>;
    getChatbotAccess(context: Context): Promise<ChatbotAccess>;
    getUserGroupNames(context: Context): Promise<string[]>;
    getConversationHistory(context: Context): Promise<ChatConversation[]>;
    createOrUpdateConversation(context: Context, conversation: Partial<ChatConversation>): Promise<string>;
    canExportList(context: Context): Promise<boolean>;
    supportedExportListTypes(context: Context): Promise<ChatbotListExportTargetExtension[]>;
    exportList(exportParams: ChatbotListExportParams, executeApiQuery: <T = unknown>(query: string) => Promise<T>): Promise<string>;
    transcribeAudioChunk?(args: TranscribeAudioChunkArgs): Promise<void>;
}
export declare class ChatbotManagerStub implements ChatbotManager {
    canExportList(): Promise<boolean>;
    supportedExportListTypes(): Promise<ChatbotListExportTargetExtension[]>;
    exportList(): Promise<string>;
    isChatbotEnabled(): Promise<boolean>;
    getChatbotAccess(): Promise<ChatbotAccess>;
    getUserGroupNames(): Promise<string[]>;
    getConversationHistory(): Promise<ChatConversation[]>;
    createOrUpdateConversation(): Promise<string>;
}
//# sourceMappingURL=chatbot-manager.d.ts.map