/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ActivityManager=void 0;const loggers_1=require("../runtime/loggers"),logger=loggers_1.loggers.authorization;class ActivityManager{#e;constructor(e){this.application=e,this._activities={},this.#e=new Set,this.#t=false}createActivities(e){Object.keys(e.activities).forEach(t=>{if(this._activities[t])return void logger.error(`Activity ${t} is declared more than once in the application and will be ignored in package ${e.name}.`);this._activities[t]=e.activities[t],this._activities[t].package=e.name}),this.mergeActivityExtensions(e)}mergeActivityExtensions(e){Object.keys(e.activitiesExtensions).forEach(t=>{const i=e.activitiesExtensions[t],s=Object.values(this._activities).indexOf(i.extends),a=Object.keys(this._activities)[s];if(this._activities[a])this._activities[a].mergeExtension(i);else throw new Error(`${i.filename}, activity linked to activity extension is not loaded on application.`)})}getActivities(){return this._activities}isNodeAccessControlled(e){if(this.#e.has(e.name))return true;if(e.isVitalChild)return this.isNodeAccessControlled(e.vitalParentFactory);return false}static checkOperation(e,t,i,s){let a=false;const checkFactoryOperation=(e,t)=>{if(e[t])return true;return e.isVitalChild&&checkFactoryOperation(e.vitalParentFactory,t)};switch(t){case"lookup":a=true;break;case"read":a=checkFactoryOperation(i,"canRead");break;case"create":a=checkFactoryOperation(i,"canCreate")||i.mutations.some(e=>e.isPublished&&"create"===e.name);break;case"update":a=checkFactoryOperation(i,"canUpdate")||i.mutations.some(e=>e.isPublished&&"update"===e.name);break;case"delete":a=checkFactoryOperation(i,"canDelete");break;case"import":a=checkFactoryOperation(i,"canCreate")||checkFactoryOperation(i,"canUpdate");break;default:a=i.mutations.some(e=>e.name===t)||i.queries.some(e=>e.name===t)}if(!a&&s?.throws)throw new Error(`Activity ${e}: invalid operation granted on Node ${i.name}, ${t} not allowed or not found.`);return a}fillGrants(){Object.values(this._activities).forEach(e=>{e.fillInternalGrants(this.application)}),Object.values(this._activities).forEach(e=>{this.#e.add(e.node.name),Object.values(e.internalGrants).forEach(e=>{Object.values(e).forEach(e=>{if(e.isOperationGrant())this.#e.add(e.node)})})});const e={};Object.values(this._activities).forEach(t=>{let i=t.fillInheritedInternalGrants(this.application,e);for(;i;)i=t.fillInheritedInternalGrants(this.application,e)});let t=true;for(;t;)t=false,Object.values(this._activities).forEach(e=>{Object.keys(e.internalGrants).forEach(i=>{Object.values(e.internalGrants[i]).filter(e=>e.isPermissionGrant()).forEach(s=>{if(s.isPermissionGrant()){const a=this._activities[s.activity],r=a?.internalGrants[s.permission]||{};Object.values(r).forEach(s=>{if(s.isOperationGrant())t=e.addGrant(i,s)})}})})});logger.info(`Filled grants of ${Object.keys(this._activities).length} activities`)}flattenPermissions(){let e=0;Object.keys(this._activities).forEach(t=>{const i=this._activities[t],s={};Object.entries(i.internalGrants).forEach(([i,a])=>{const r={};Object.values(a).forEach(e=>{if(e.isOperationGrant()){const i=e.node,s=this.application.getFactoryByName(i);if(ActivityManager.checkOperation(t,e.operation,s)){if(!r[e.operation])r[e.operation]=[];if(!r[e.operation].includes(i))r[e.operation].push(i)}}}),s[i]=r,e++}),i.flattenedPermissions=s}),logger.info(`Flatten ${e} permissions among ${Object.keys(this._activities).length} activities`)}#t;resolvePermissions(){if(!this.#t){this.#t=true;let e=logger.verbose(()=>`Filling grants of ${Object.keys(this._activities).length} activities`);this.fillGrants(),e.success(),e=logger.verbose(()=>"Setting permissions"),this.flattenPermissions(),e.success()}}}exports.ActivityManager=ActivityManager;
//# sourceMappingURL=activity-manager.js.map