import { Dict } from '@sage/xtrem-shared';
import { NodeFactory } from '../runtime/node-factory';
import { Activity } from '../ts-api/activity';
import { Application } from './application';
export declare class ActivityManager {
    #private;
    private application;
    private _activities;
    constructor(application: Application);
    /**
     * Get the activities for the application
     */
    getActivities(): Dict<Activity>;
    /**
     * Check if the node is access controlled, recursively checking the parent
     * @param factory
     */
    isNodeAccessControlled(factory: NodeFactory): boolean;
    /**
     * Check the if the permission is allowed for the factory passed
     */
    static checkOperation(activityName: string, operation: string, factory: NodeFactory, options?: {
        throws?: boolean;
    }): boolean;
    /**
     * Fill each activity with all its derived and inherited grants
     */
    private fillGrants;
    /**
     * Flatten the activity permissions to a structure like
     * SalesOrder { read: [{read:{ SaleOrderLine }, lookup:{ SaleOrderLine }}]}
     */
    private flattenPermissions;
    /** Resolve activity permissions into a fully resolved flattened permission  list */
    resolvePermissions(): void;
}
//# sourceMappingURL=activity-manager.d.ts.map