export type LogParams = string | Error | Record<string, unknown> | unknown;
export type Event = {
    [key: string]: unknown;
    headers?: Record<string, string>;
};
export type Request = {
    [key: string]: unknown;
    body?: string;
    headers?: Record<string, string>;
};
export type Globals = {
    CONTEXT?: Record<string, unknown>;
};
export type ReturnTypeWithArgs<T extends (...args: any[]) => any, ARGS_T> = Extract<T extends {
    (...args: infer A1): infer R1;
    (...args: infer A2): infer R2;
    (...args: infer A3): infer R3;
    (...args: infer A4): infer R4;
} ? [A1, R1] | [A2, R2] | [A3, R3] | [A4, R4] : T extends {
    (...args: infer A1): infer R1;
    (...args: infer A2): infer R2;
    (...args: infer A3): infer R3;
} ? [A1, R1] | [A2, R2] | [A3, R3] : T extends {
    (...args: infer A1): infer R1;
    (...args: infer A2): infer R2;
} ? [A1, R1] | [A2, R2] : T extends {
    (...args: infer A1): infer R1;
} ? [A1, R1] : never, [
    ARGS_T,
    any
]>[1];
export declare const getErrorMsg: (error: unknown) => string;
declare function isDebugEnabled(): boolean;
declare const Tools: {
    Context: {
        clearAll: () => undefined;
        replaceAllWith: (ctx: Record<string, unknown>) => Record<string, unknown>;
        set: (key: string, value: string) => void;
        get: () => Record<string, unknown>;
        responseWithContextHeaders: (request: Request, headersObj?: Record<string, string>) => Request;
        setRequestContext: (event: Event, context: {
            [key: string]: string;
        }) => void;
    };
    Log: {
        isDebugLoggingEnabled: typeof isDebugEnabled;
        debug: (msg: string, params?: LogParams) => string | undefined;
        info: (msg: string, params?: LogParams) => string | undefined;
        warn: (msg: string, params?: LogParams) => string | undefined;
        error: (msg: string, params?: LogParams) => string | undefined;
        security: (msg: string, params?: LogParams) => string | undefined;
        audit: (msg: string, params?: LogParams) => string | undefined;
        _setConsoleSilent: (value: boolean) => void;
        _setLogToString: (value: boolean) => void;
    };
    obfuscate: (txt: string, lastCharNbPercentToObfuscate?: number) => string;
    deepObfuscate: (obj: unknown, lastCharNbPercentToObfuscate?: number) => unknown;
};
export default Tools;
