// eslint.config.mjs (ESLint v9+)
import { defineConfig, globalIgnores } from 'eslint/config';
import globals from 'globals';
import baseConfig from '../../eslint-base.config.mjs';

export default defineConfig([
    globalIgnores(['build/**', 'tmp/**', 'node_modules/**', '**/coverage', '**/i18n/*.json']),
    {
        languageOptions: {
            parserOptions: {
                parser: '@typescript-eslint/parser',
                projectService: true,
                tsconfigRootDir: import.meta.dirname,
                project: ['tsconfig.json'],
                extraFileExtensions: ['.json'],
            },
        },
    },
    ...baseConfig,
    {
        files: ['lib/**/*.ts'],
        rules: {
            '@typescript-eslint/explicit-function-return-type': [
                'error',
                {
                    allowExpressions: true,
                },
            ],
        },
    },
    {
        files: ['**/*.js'],
        rules: {
            '@typescript-eslint/no-require-imports': 'off',
        },
    },
    // config envs
    {
        languageOptions: {
            globals: { ...globals.browser, ...globals.node },
        },
    },
]);
