import { AnyValue } from '@sage/xtrem-shared';
import { ConverterFactory, ConverterProperty, GenericConversionResult } from './types';
export interface Resolver<ContextT, FactoryT extends ConverterFactory, PropertyT extends ConverterProperty> {
    resolveColumnName: (cx: ContextT, parent: GenericConversionResult<FactoryT, PropertyT>, propertyName: string) => GenericConversionResult<FactoryT, PropertyT>;
    resolveTableName: (factory: FactoryT) => string;
    resolveLiteral: (value: AnyValue) => string;
}
export declare class BasicResolver<ContextT, FactoryT extends ConverterFactory, PropertyT extends ConverterProperty> implements Resolver<ContextT, FactoryT, PropertyT> {
    resolveColumnName(_cx: ContextT, parent: GenericConversionResult<FactoryT, PropertyT>, propertyName: string): GenericConversionResult<FactoryT, PropertyT>;
    resolveTableName(factory: FactoryT): string;
    resolveLiteral(value: AnyValue): string;
}
//# sourceMappingURL=resolver.d.ts.map