/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.EsLintConverter=void 0;const conversion_error_1=require("./conversion-error"),converter_1=require("./converter"),registry_1=require("./registry"),resolver_1=require("./resolver");class EsLintConverter extends converter_1.Converter{static{this.knownFunctions=["xtremFinance.functions.signedAmount","xtremFinanceData.functions.getFinancialSite","xtremMasterData.sharedFunctions.convertAmount","xtremMasterData.functions.computeDiscountChargeValue","xtremMasterData.functions.computeDiscountChargeValueDeterminated","xtremMasterData.functions.itemSiteCost.getStandardCostAt","PurchaseInvoiceLine.getVarianceType","xtremLandedCost.nodes.LandedCostLine.getTotalActualCostAmountInCompanyCurrency","xtremPurchasing.functions.BaseDocument.getCurrencyDecimalDigits","xtremPurchasing.functions.PurchaseCreditMemoLib.getPurchaseReceiptLineFromInvoiceLine","xtremPurchasing.functions.PurchaseCreditMemoLib.getPurchaseReceiptLineFromReturnLine","xtremStockData.functions.allocationLib.getLineAllocationStatus","xtremTechnicalData.sharedFunctions.componentFunctions.getQuantityWithScrap","xtremTechnicalData.functions.bomRevisionLib.getBomRevisionValidTo","xtremTechnicalData.functions.bomRevisionLib.getRevisionByDate","xtremTechnicalData.functions.componentFunctions.getComponentCostDate","sageX3Finance.functions.getLedgerAmountDebit","sageX3Finance.functions.getLedgerAmountCredit","sageX3Finance.functions.getLedgerAmountBalance","sageX3Finance.functions.getTransactionAmountDebit","sageX3Finance.functions.getTransactionAmountCredit","sageX3Finance.functions.getTransactionAmountBalance","sageX3Purchasing.functions.getRemainingQuantityToReceiveInPurchaseUnit","sageX3Purchasing.functions.getRemainingAmountToReceive","sageX3Sales.functions.getRealClosingDate"]}static{EsLintConverter.knownFunctions.forEach(e=>{const n={fullName:e,fn:e=>({sql:`eslint dummy SQL ${e}`}),parameterNames:["foo"]};registry_1.registry.registerConvertibleFunction(n)})}constructor(e=null){super(e,{name:"DummyFactory",tableName:"DummyTable"},new resolver_1.BasicResolver,{dialect:"postgres"}),this.dummy=registry_1.registry.registerEsLintMembers()}getCommonType(){return"decimal"}convertRegistryFunctionCall(e,n,t){if(!EsLintConverter.knownFunctions.includes(n.fullName))throw new conversion_error_1.ConversionError(e,`Unsupported static call: ${n.fullName}`);return t.forEach(e=>this.convertExpression(e)),{type:"unknown",sql:"<eslint sql>"}}}exports.EsLintConverter=EsLintConverter;
//# sourceMappingURL=eslint-converter.js.map