import * as estree from 'estree';
import { Converter } from './converter';
import { ConvertibleFunctionEntry } from './registry';
import { BasicConversionResult, ConversionResultType } from './types';
/**
 * Special converter for ESLint plugin
 *
 * The plugin does not have the metadata required to convert the code to SQL.
 * So it cannot check the types. This may lead to false positives in the linting.
 */
export declare class EsLintConverter extends Converter {
    static knownFunctions: string[];
    dummy: void;
    constructor(context?: any);
    protected getCommonType(): ConversionResultType;
    protected convertRegistryFunctionCall(callExpression: estree.CallExpression, functionEntry: ConvertibleFunctionEntry, args: (estree.Expression | estree.SpreadElement)[]): BasicConversionResult;
}
//# sourceMappingURL=eslint-converter.d.ts.map