/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Converter=void 0,exports.quote=quote,exports.sqlNumber=sqlNumber;const xtrem_shared_1=require("@sage/xtrem-shared"),logger_1=require("./logger"),walker_1=require("./walker"),conversion_error_1=require("./conversion-error"),array_converter_1=require("./converter-lib/array-converter"),date_1=require("./converter-lib/date"),regexp_converter_1=require("./converter-lib/regexp-converter"),string_converter_1=require("./converter-lib/string-converter"),registry_1=require("./registry"),type_converter_1=require("./type-converter"),types_1=require("./types"),parse=require("espree").parse;function quote(e){return`'${e.replace(/'/g,"''")}'`}function sqlNumber(e,r){const t="number"==typeof r?r:parseFloat(String(r));if(!Number.isFinite(t))throw new xtrem_shared_1.DataInputError(`${e.factory?.name}.${e.property?.name}: invalid numeric value: '${r}'`);return t.toString()}class Converter extends walker_1.Walker{constructor(e,r,t,n){super(e,r,t,n),this.typeConverter=new type_converter_1.TypeConverter(this.dialect)}get dialect(){return this.options.dialect}get dateConverter(){switch(this.dialect){case"oracle":return new date_1.OracleDateConverter(this);case"postgres":return new date_1.PostgresDateConverter(this);case"sqlServer":return new date_1.SqlServerDateConverter(this);default:throw new conversion_error_1.ConversionError(void 0,`unsupported dialect: ${this.dialect}`)}}get regexConverter(){return new regexp_converter_1.RegExpConverter(this)}get stringConverter(){return new string_converter_1.StringConverter(this)}cast(e,r){if(e.type===r||"unknown"===r||"NULL"===e.sql.toUpperCase())return e;if("date"===r&&"oracle"===this.dialect)return this.typeConverter.castOracleDate(e,r);const t=this.typeConverter.sqlType(r),n="postgres"===this.dialect?`${e.sql}::${t}`:`CAST(${e.sql} AS ${t})`;return{...e,type:r,sql:n}}static booleanResult(e){return{type:"boolean",sql:e}}static stringResult(e){return{type:"string",sql:e}}convertDatePropertyResult(e,r){const t=registry_1.registry.getPropertyEntry("date",r);if(!t)throw new conversion_error_1.ConversionError(void 0,`unknown property ${r}`);return t.convertExpression(this,e,r)}convertMemberExpression(e,r=false){const t=this.convertExpression(e.object,true);if(r){if(t.property&&!t.property.isNullable&&!t.isNullable)throw new conversion_error_1.ConversionError(e.property,`The member ${t.property.name} is not nullable. Please consider using a statement like 'this.${t.property.name}.foo' instead of 'this.${t.property.name}?.foo'`);if(t.join)t.join.isNullable=true;t.isNullable=true}if("Identifier"!==e.property.type)throw new conversion_error_1.ConversionError(e.property,"property is not a literal");const n=e.property.name,o=t.type,s=registry_1.registry.getPropertyEntry(o,n);if(s)return s.convertExpression(this,t,n);return this.walk(t,n)}convertChainExpression(e){if("MemberExpression"!==e.expression.type)throw new conversion_error_1.ConversionError(e.expression,"kind of chain expression not supporterd");return this.convertMemberExpression(e.expression,true)}checkResultType(e,r,t){if("unknown"!==r.type&&r.type!==t)throw new conversion_error_1.ConversionError(e,`Invalid type: expected ${t}, got: ${r.type}`)}getCommonType(e,r){const t=r.reduce((r,t)=>{const n=t.type;if(r===n)return n;if("unknown"===r||"json"===r)return n;if("unknown"===n)return r;const pickCommonType=(e,t)=>{if(e.includes(r)&&n===t)return t;if(e.includes(n)&&r===t)return t;return null},o=pickCommonType(["integer","short"],"decimal")??pickCommonType(["short"],"integer")??pickCommonType(["enum"],"string")??pickCommonType(["reference"],"integer");if(!o){if("string"===r||"string"===n)return"string";throw new conversion_error_1.ConversionError(e,`incompatible types: ${r} and ${n}`)}return o},"unknown");if(null==t)throw new conversion_error_1.ConversionError(e,"no common type");return t}convertToCommonType(e,r,t){const n=this.getCommonType(e,[r,t]);return[n,this.cast(r,n),this.cast(t,n)]}convertToBooleanExpression(e){const r=this.convertExpression(e);return this.checkResultType(e,r,"boolean"),r}convertConditionalExpression(e){const r=this.convertToBooleanExpression(e.test),t=this.convertExpression(e.consequent),n=this.convertExpression(e.alternate),[o,s,i]=this.convertToCommonType(e,t,n);return{type:o,sql:`(CASE WHEN ${r.sql} THEN ${s.sql} ELSE ${i.sql} END)`}}convertNullEqualityExpression(e){if("Literal"!==e.right.type||null!==e.right.value)throw new conversion_error_1.ConversionError(e.right,"== and !=  operations can only be used with null");const r=this.convertExpression(e.left),t="=="===e.operator?"IS":"IS NOT";return Converter.booleanResult(`(${r.sql} ${t} NULL)`)}convertBinaryExpression(e){const r=e.operator;if("=="===r||"!="===r)return this.convertNullEqualityExpression(e);const t=this.convertExpression(e.left),n=this.convertExpression(e.right);switch(r){case"+":{const o=t.type,s=n.type;if("string"===o||"string"===s)return Converter.stringResult(this.concat([t.sql,n.sql]));const[i,c,a]=this.convertToCommonType(e,t,n);return{type:i,sql:`(${c.sql} ${r} ${a.sql})`}}case"-":case"*":case"/":{const[o,s,i]=this.convertToCommonType(e,t,n);if(!this.typeConverter.isNumericType(o))throw new conversion_error_1.ConversionError(e,`invalid type for operator ${r}: ${o}`);return{type:o,sql:`(${s.sql} ${r} ${i.sql})`}}case"<":case"<=":case">":case">=":{const[,o,s]=this.convertToCommonType(e,t,n);return Converter.booleanResult(`(${o.sql} ${r} ${s.sql})`)}case"===":case"!==":{if("Literal"===e.right.type&&null===e.right.value)throw new conversion_error_1.ConversionError(e.right,"=== and !==  operators cannot be used with null (use == or != instead)");const o="==="===r?"=":"!=",s="!=="===r&&t.isNullable?` OR (${t.sql} IS NULL)`:"",[,i,c]=this.convertToCommonType(e,t,n);return Converter.booleanResult(`(${i.sql} ${o} ${c.sql})${s}`)}default:throw new conversion_error_1.ConversionError(e,`cannot convert operator: ${r}`)}}convertBooleanLogicalExpression(e){const r=this.convertToBooleanExpression(e.left),t=this.convertToBooleanExpression(e.right);switch(e.operator){case"&&":return Converter.booleanResult(`${r.sql} AND ${t.sql}`);case"||":return Converter.booleanResult(`(${r.sql} OR ${t.sql})`);default:throw new conversion_error_1.ConversionError(e,`cannot convert operator: ${e.operator}`)}}convertLogicalExpression(e){switch(e.operator){case"&&":case"||":return this.convertBooleanLogicalExpression(e);case"??":{const r=this.convertExpression(e.left),t=this.convertExpression(e.right);return{type:this.getCommonType(e,[r,t]),sql:`(CASE WHEN ${r.sql} IS NULL THEN ${t.sql} ELSE ${r.sql} END)`,factory:r.factory??t.factory}}default:throw new conversion_error_1.ConversionError(e,`cannot convert operator: ${e.operator}`)}}convertUnaryExpression(e){const r=this.convertExpression(e.argument),t=e.operator;switch(t){case"!":return this.convertNotArgument(r);case"-":return{type:r.type,sql:`(- ${this.cast({sql:r.sql,type:"unknown"},r.type).sql})`};default:throw new conversion_error_1.ConversionError(e,`Unsupported unary operator: ${t}`)}}convertNotArgument(e){let r="";switch(e.type){case"integer":case"short":r=this.resolver.resolveLiteral("0"===e.sql);break;case"reference":r=`(${e.sql} IS NULL)`;break;default:r=`(NOT ${e.sql})`}return Converter.booleanResult(r)}concat(e){return`CONCAT(${e.join(",")})`}convertTemplateLiteral(e){const r=[];return e.expressions.forEach((t,n)=>{r.push(this.convertExpression(e.quasis[n]).sql),r.push(this.convertExpression(e.expressions[n]).sql)}),r.push(this.convertExpression(e.quasis[e.quasis.length-1]).sql),Converter.stringResult(this.concat(r))}convertTemplateElementString(e){return quote(e)}convertTemplateElement(e){return Converter.stringResult(this.convertTemplateElementString(e.value.cooked||""))}convertLiteral(e,r){if("bigint"==typeof e)throw new xtrem_shared_1.SystemError(`cannot convert bigint literal: ${e}`);const t={sql:this.resolver.resolveLiteral(e),type:"boolean"==typeof e?"boolean":"number"==typeof e?"integer":"string"==typeof e?"string":"unknown"};return r&&["integer","boolean"].includes(r.type)?this.cast(t,r.type):t}convertPropertyAssignments(e){if("Identifier"!==e.key.type)throw new Error(`Invalid property type ${e.key.type}`);return{sql:`${(0,types_1.getColumnName)(e.key.name)} = ${this.convertExpression(e.value).sql}`,type:"void"}}convertObjectAssignments(e){const r=[];return e.properties.forEach(e=>{if("Property"!==e.type)throw new Error(`Invalid object member ${e.type}`);const t=this.convertPropertyAssignments(e);r.push(t.sql)}),{type:"void",sql:r.join(",")}}convertNaryCallExpression(e,r){if(0===e.arguments.length)throw new conversion_error_1.ConversionError(e,"no arguments");const t=e.arguments.map(e=>this.convertExpression(e));return{type:this.getCommonType(e,t),sql:`${r}(${t.map(e=>e.sql).join(",")})`}}getConfigurationValue(e){return""}convertIdentifier(e){return this.variableScope.resolve(e.name)}convertArgs(e,r,t){if(e.length!==r.length)throw new conversion_error_1.ConversionError(e[0],`${t}: expected ${r.length} argument(s), got ${e.length}`);return e.map((e,n)=>{const o=this.convertExpression(e);if(o.type!==r[n])throw new conversion_error_1.ConversionError(e,`${t}: expected argument ${n+1} of type ${r[n]}, got type ${o.type}`);return o})}convertMethodCall(e,r,t,n){const o=r.extraType??r.type,s=registry_1.registry.getMethodEntry(o,t);if(!s)throw new conversion_error_1.ConversionError(e,`cannot find method ${t} on type ${o}`);return s.convertExpression(this,r,n,t)}getFullMemberName(e){if("Identifier"!==e.property.type)throw new conversion_error_1.ConversionError(e.property,"cannot convert: expected an identifier");if("Identifier"===e.object.type)return`${e.object.name}.${e.property.name}`;if("MemberExpression"===e.object.type){return`${this.getFullMemberName(e.object)}.${e.property.name}`}return e.property.name}convertRegistryFunctionCall(e,r,t){if(!r.parsedFunction)r.parsedFunction=this.parseFunction(r.fn);const n=t.map(e=>this.convertExpression(e));this.pushVariableScope();try{return r.parameterNames.forEach((e,r)=>{const t=n[r];this.variableScope.set(e,t)}),this.convertFunctionBodyExpression(r.parsedFunction)}catch(t){throw new conversion_error_1.ConversionError(e,`Cannot convert ${r.fullName}`,t)}finally{this.popVariableScope()}}convertMemberCallExpression(e,r){if("Identifier"!==r.property.type)throw new conversion_error_1.ConversionError(r.property,"expected an identifier");let t=this.getFullMemberName(r);const n=/^\w+_\d+\./.test(t);if(n)t=t.split(".").slice(1).join(".");const o=registry_1.registry.getFunctionEntry(t);if(o){if(o.fn)return this.convertRegistryFunctionCall(e,o,e.arguments);return o.convertExpression(this,e,e.arguments,t)}if(n)throw new conversion_error_1.ConversionError(r,`${t}: Unsupported ${t.split(".")[0]} function`);if("Identifier"===r.object.type){const t=this.variableScope.peekVariable(r.object.name);if(t)return this.convertMethodCall(e,t,r.property.name,e.arguments)}if("Literal"===r.object.type&&r.object.value instanceof RegExp&&"Identifier"===r.property.type)return this.regexConverter.convertMethodCall(e,r.object.value,r.property.name,e.arguments);if("ArrayExpression"===r.object.type){if("Identifier"!==r.property.type)throw new conversion_error_1.ConversionError(r.property,"cannot convert: expected an identifier");return new array_converter_1.ArrayConverter(this).convertLiteralMethodCall(r.object,r.property.name,e.arguments)}if("Identifier"===r.object.type)throw new conversion_error_1.ConversionError(r,`${t}: Unsupported ${t.split(".")[0]} function`);const s=this.convertExpression(r.object,true);return this.convertMethodCall(e,s,r.property.name,e.arguments)}convertCallExpression(e){if("MemberExpression"===e.callee.type)return this.convertMemberCallExpression(e,e.callee);if("SequenceExpression"===e.callee.type&&2===e.callee.expressions.length&&"Literal"===e.callee.expressions[0].type&&0===e.callee.expressions[0].value&&"MemberExpression"===e.callee.expressions[1].type&&"Identifier"===e.callee.expressions[1].property.type&&"notNull"===e.callee.expressions[1].property.name&&1===e.arguments.length)return this.convertExpression(e.arguments[0]);throw new conversion_error_1.ConversionError(e,"Unsupported call")}convertTSNonNullExpression(e){return this.convertExpression(e.expression)}convertTSAsExpression(e){return this.convertExpression(e.expression)}convertAwaitExpression(e){return this.convertExpression(e.argument)}_convertExpression(e,r=false){switch(e.type){case"TSNonNullExpression":return this.convertTSNonNullExpression(e);case"TSAsExpression":return this.convertTSAsExpression(e);case"MemberExpression":return this.convertMemberExpression(e);case"ChainExpression":return this.convertChainExpression(e);case"ThisExpression":return this.convertThisExpression(r);case"AwaitExpression":return this.convertAwaitExpression(e);case"Literal":return this.convertLiteral(e.value);case"Identifier":return this.convertIdentifier(e);case"TemplateLiteral":return this.convertTemplateLiteral(e);case"TemplateElement":return this.convertTemplateElement(e);case"BinaryExpression":return this.convertBinaryExpression(e);case"LogicalExpression":return this.convertLogicalExpression(e);case"UnaryExpression":return this.convertUnaryExpression(e);case"CallExpression":return this.convertCallExpression(e);case"ObjectExpression":return this.convertObjectAssignments(e);case"ConditionalExpression":return this.convertConditionalExpression(e);default:throw new conversion_error_1.ConversionError(e,`invalid expression type: ${e.type}`)}}convertExpression(e,r=false){try{return this._convertExpression(e,r)}catch(r){if(r instanceof conversion_error_1.ConversionError&&!r.node)r.node=e;throw r}}convertVariableDeclaration(e){if("const"!==e.kind)throw new conversion_error_1.ConversionError(e,"only const declarations allowed");e.declarations.forEach(e=>{if("VariableDeclarator"!==e.type)throw new conversion_error_1.ConversionError(e,`expected VariableDeclarator, got ${e.type}`);if("Identifier"!==e.id.type)throw new conversion_error_1.ConversionError(e.id,`expected Identifier, got ${e.id.type}`);if(!e.init)throw new conversion_error_1.ConversionError(e,"missing initializer");const r=e.id.name,t=this.convertExpression(e.init);this.variableScope.set(r,t)})}convertExpressionStatement(e){if("CallExpression"===e.expression.type&&"MemberExpression"===e.expression.callee.type&&"Identifier"===e.expression.callee.object.type&&"console"===e.expression.callee.object.name)return;throw new conversion_error_1.ConversionError(e,`expected a console.xyz(...) call, got ${e.expression.type}`)}convertIfStatement(e){if(e.alternate)throw new conversion_error_1.ConversionError(e.alternate,"else clause not allowed");const r=this.convertToBooleanExpression(e.test).sql;let t;if("BlockStatement"===e.consequent.type)t=this.convertStatements(e.consequent.body);else t=this.convertStatements([e.consequent]);return{statement:e,test:r,consequent:t}}convertReturnStatement(e){if(!e.argument)throw new conversion_error_1.ConversionError(e,"expression missing after return");return this.convertExpression(e.argument)}convertStatements(e){this.pushVariableScope();const r=[];for(let t=0;t<e.length-1;t+=1){const n=e[t];switch(n.type){case"ExpressionStatement":this.convertExpressionStatement(n);break;case"VariableDeclaration":this.convertVariableDeclaration(n);break;case"IfStatement":r.push(this.convertIfStatement(n));break;default:throw new conversion_error_1.ConversionError(n,`expected an if statement, a const declaration or a console.xyz(...) call, got a statement of type ${n.type}`)}}const t=e[e.length-1];if("ReturnStatement"!==t.type)throw new conversion_error_1.ConversionError(e[0],`expected return statement, got ${e[0].type}`);const n=this.convertReturnStatement(t);this.popVariableScope();const buildResult=()=>{const e=r.shift();if(void 0===e)return n;const t=buildResult();return{type:this.getCommonType(e.statement,[e.consequent,t]),sql:`(CASE WHEN ${e.test} THEN ${e.consequent.sql} ELSE ${t.sql} END)`}};return buildResult()}convertFunctionExpression(e){const r=e.body.body;if(0===r.length)throw new conversion_error_1.ConversionError(e.body,"cannot convert empty block to SQL");return this.convertStatements(r)}convertArrowFunctionExpression(e){if(null==e.body.body)return this.convertExpression(e.body);return this.convertFunctionExpression(e)}parseFunctionSource(e){try{const r=parse(e,{ecmaVersion:2022,loc:true});if("Program"!==r.type)throw new conversion_error_1.ConversionError(r,`expected Program, got ${r.type}`);const t=r.body[0];if(!t)throw new conversion_error_1.ConversionError(r,"no program body");if("ExpressionStatement"!==t.type)throw new conversion_error_1.ConversionError(r,`expected ExpressionStatement, got ${t.type}`);const n=["FunctionExpression","ArrowFunctionExpression"],o=t.expression;if(!n.includes(o.type))throw new conversion_error_1.ConversionError(r,`expected ${n.join(" or ")}, got ${o.type}`);return o}catch(r){if(!this.options.quiet)(0,logger_1.getLogger)().error(`Failed to convert function in factory ${this.rootFactory.name}: ${e}`);throw r}}parseFunction(e){let r=(0,xtrem_shared_1.removeCodeCoverageInstrumentation)(e.toString()).trim();if(0===r.length)throw new Error(`Source missing for ${e.name}`);if(r.startsWith("async "))r=r.replace(/^async (\w+)/,"async function");else if(!r.startsWith("function ")&&!r.startsWith("("))r=`async function ${r}`;return r=`(${r})`,this.parseFunctionSource(r)}convertFunctionBodyExpression(e){return"ArrowFunctionExpression"===e.type?this.convertArrowFunctionExpression(e):this.convertFunctionExpression(e)}convertFunctionSource(e){return this.convertFunctionBodyExpression(this.parseFunctionSource(e))}convertFunction(e){return this.convertFunctionBodyExpression(this.parseFunction(e))}convertFunctionBody(e,r){return this.withThisResultScope(e,()=>this.convertFunctionSource(`(function() { return (${r}); })`))}static{this.safeStringLiterals=new Set([""," ","%","year","quarter","month","day","week","dow","doy","1 day","1 year - 1 day","1 month - 1 day","3 month - 1 day","1 week - 1 day"])}static addSafeStringLiterals(e){e.forEach(e=>this.safeStringLiterals.add(e))}static isSafeStringLiteral(e){return this.safeStringLiterals.has(e)}}exports.Converter=Converter;
//# sourceMappingURL=converter.js.map