import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
import * as estree from 'estree';
import { Walker } from './walker';
import { DateConverter } from './converter-lib/date';
import { RegExpConverter } from './converter-lib/regexp-converter';
import { StringConverter } from './converter-lib/string-converter';
import { ConvertibleFunctionEntry } from './registry';
import { Resolver } from './resolver';
import { TypeConverter } from './type-converter';
import { BasicConversionResult, ConversionResultType, ConverterFactory, ConverterOptions, ConverterProperty, Dialect, GenericConversionResult } from './types';
export declare function quote(s: string): string;
/**
 * Convert numeric value `val` to a SQL string.
 * Throws an error if `val` is not a valid number.
 */
export declare function sqlNumber(slot: BasicConversionResult, val: AnyValue): string;
export interface CastOptions<PropertyT extends ConverterProperty = ConverterProperty> {
    type: ConversionResultType;
    property?: PropertyT;
}
interface IfSqlResult {
    statement: estree.IfStatement;
    test: string;
    consequent: BasicConversionResult;
}
export declare class Converter<ContextT = unknown, FactoryT extends ConverterFactory = ConverterFactory, PropertyT extends ConverterProperty = ConverterProperty> extends Walker<ContextT, FactoryT, PropertyT> {
    readonly typeConverter: TypeConverter;
    constructor(context: ContextT, rootFactory: FactoryT, resolver: Resolver<ContextT, FactoryT, PropertyT>, options: ConverterOptions);
    get dialect(): Dialect;
    get dateConverter(): DateConverter;
    get regexConverter(): RegExpConverter;
    get stringConverter(): StringConverter;
    cast(result: BasicConversionResult, type: ConversionResultType): BasicConversionResult;
    static booleanResult(sql: string): BasicConversionResult;
    static stringResult(sql: string): BasicConversionResult;
    convertDatePropertyResult(result: GenericConversionResult, propertyName: string): BasicConversionResult;
    private convertMemberExpression;
    private convertChainExpression;
    checkResultType(expression: estree.BaseExpression, result: BasicConversionResult, expectedType: ConversionResultType): void;
    protected getCommonType(expression: estree.BaseNode, results: BasicConversionResult[]): ConversionResultType;
    private convertToCommonType;
    protected convertToBooleanExpression(expression: estree.Expression): BasicConversionResult;
    private convertConditionalExpression;
    private convertNullEqualityExpression;
    protected convertBinaryExpression(expression: estree.BinaryExpression): BasicConversionResult<FactoryT, PropertyT>;
    private convertBooleanLogicalExpression;
    private convertLogicalExpression;
    private convertUnaryExpression;
    private convertNotArgument;
    protected concat(strings: string[]): string;
    private convertTemplateLiteral;
    convertTemplateElementString(str: string): string;
    convertTemplateElement(expression: estree.TemplateElement): BasicConversionResult;
    convertLiteral(value: AnyValue | RegExp | bigint, object?: BasicConversionResult): BasicConversionResult;
    /**
     * Converts an item of an object (see convertObject) a:'aaa' -> "a = 'aaa'" / c:d -> "c = t0.d"
     */
    private convertPropertyAssignments;
    /**
     * Converts an object {a:'aaa', b:'bbb', c:d} into sth like "a='aaa', b='bbb', c=t0.d"
     * Can be used for update ... set ... operations
     */
    private convertObjectAssignments;
    convertNaryCallExpression(expression: estree.BaseCallExpression, sqlFunctionName: string): BasicConversionResult;
    getConfigurationValue(_name: string): string;
    private convertIdentifier;
    /**
     * Convert a list of arguments to a list of conversion results,
     * after checking their type.
     */
    convertArgs(args: estree.BaseExpression[], types: ConversionResultType[], name: string): BasicConversionResult[];
    protected convertMethodCall(expression: estree.CallExpression, result: BasicConversionResult, methodName: string, args: (estree.Expression | estree.SpreadElement)[]): BasicConversionResult;
    private getFullMemberName;
    protected convertRegistryFunctionCall(callExpression: estree.CallExpression, functionEntry: ConvertibleFunctionEntry, args: (estree.Expression | estree.SpreadElement)[]): BasicConversionResult;
    protected convertMemberCallExpression(expression: estree.CallExpression, member: estree.MemberExpression): BasicConversionResult;
    private convertCallExpression;
    private convertTSNonNullExpression;
    private convertTSAsExpression;
    private convertAwaitExpression;
    private _convertExpression;
    convertExpression(expression: estree.BaseExpression, isMemberOf?: boolean): BasicConversionResult<FactoryT, PropertyT>;
    convertVariableDeclaration(statement: estree.VariableDeclaration): void;
    private convertExpressionStatement;
    convertIfStatement(statement: estree.IfStatement): IfSqlResult;
    convertReturnStatement(statement: estree.ReturnStatement): BasicConversionResult;
    convertStatements(statements: estree.Statement[]): BasicConversionResult;
    convertFunctionExpression(expression: estree.FunctionExpression | estree.ArrowFunctionExpression): BasicConversionResult;
    convertArrowFunctionExpression(expression: estree.ArrowFunctionExpression): BasicConversionResult;
    parseFunctionSource(str: string): estree.ArrowFunctionExpression | estree.FunctionExpression;
    parseFunction(fn: Function): estree.ArrowFunctionExpression | estree.FunctionExpression;
    convertFunctionBodyExpression(expression: estree.ArrowFunctionExpression | estree.FunctionExpression): BasicConversionResult;
    convertFunctionSource(str: string): BasicConversionResult;
    convertFunction(fn: () => AsyncResponse<AnyValue>): BasicConversionResult;
    convertFunctionBody(result: GenericConversionResult<FactoryT, PropertyT>, body: string): BasicConversionResult;
    private static readonly safeStringLiterals;
    static addSafeStringLiterals(literals: string[]): void;
    static isSafeStringLiteral(literal: string): boolean;
}
export {};
//# sourceMappingURL=converter.d.ts.map