import * as estree from 'estree';
import { Converter } from '../converter';
import { BasicConversionResult } from '../types';
/**
 * Converts Math function calls to SQL.
 */
export declare class TypesLibConverter {
    /**
     * Mapping of typesLib.* functions to "classic" expressions
     * For instance, typesLib.strictEq(a, b) will be mapped to a === b
     */
    static convertTypesLibExpression(converter: Converter, _expression: estree.CallExpression, op: string, args: estree.BaseExpression[]): BasicConversionResult;
    static convertTypesLibDecimalConstructorCall(converter: Converter, expression: estree.CallExpression, args: estree.BaseExpression[]): BasicConversionResult;
    static convertStaticMinMaxCall(converter: Converter, expression: estree.CallExpression, sqlName: string, args: estree.BaseExpression[]): BasicConversionResult;
    static register(): void;
}
//# sourceMappingURL=types-lib-converter.d.ts.map