/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StringConverter=void 0;const conversion_error_1=require("../conversion-error"),converter_1=require("../converter"),registry_1=require("../registry");class StringConverter{constructor(r){this.converter=r,this.convertArgs=this.converter.convertArgs.bind(this.converter)}convertLengthProperty(r){return{type:"integer",sql:`LENGTH(${r.sql})`}}convertTrimCall(r,e){if(0!==e.length)throw new conversion_error_1.ConversionError(void 0,`cannot convert trim to SQL: expected 0 args, got ${e.length}`);return converter_1.Converter.stringResult(`TRIM(${r.sql})`)}convertLikeFunction(r,e,t,n){const[o]=this.convertArgs(t,["string"],r);return{...e,type:"boolean",sql:`${e.sql} ILIKE FORMAT($$${n}$$, CAST(${o.sql} AS TEXT))`}}convertStartsWithCall(r,e){return this.convertLikeFunction("string.startsWith",r,e,"%s%%")}convertEndsWithCall(r,e){return this.convertLikeFunction("string.endsWith",r,e,"%%%s")}convertIncludesCall(r,e){return this.convertLikeFunction("string.includes",r,e,"%%%s%%")}convertIsEmptyCall(r,e){if(1!==e.length)throw new conversion_error_1.ConversionError(r,`StringUtils.isEmpty: expected 1 argument, got ${e.length}`);const t=this.converter.convertExpression(e[0]).sql;return{type:"boolean",sql:`(${t}::TEXT IS NULL OR ${t}::TEXT = '')`}}convertToChar(r){if("date"===r.type)return this.converter.dateConverter.convertToChar(r);switch(this.converter.dialect){case"postgres":return`${r.sql}::TEXT`;case"oracle":return`TO_CHAR(${r.sql})`;case"sqlServer":return`CONVERT(VARCHAR(max),${r.sql})`;default:throw new conversion_error_1.ConversionError(void 0,`${this.converter.dialect}: cannot convert to char`)}}static register(){registry_1.registry.registerMethods("string",{trim:(r,e,t)=>new StringConverter(r).convertTrimCall(e,t),startsWith:(r,e,t)=>new StringConverter(r).convertStartsWithCall(e,t),endsWith:(r,e,t)=>new StringConverter(r).convertEndsWithCall(e,t),includes:(r,e,t)=>new StringConverter(r).convertIncludesCall(e,t)}),registry_1.registry.registerProperties("string",{length:(r,e)=>new StringConverter(r).convertLengthProperty(e)}),registry_1.registry.registerBuiltInFunctions({"StringUtils.isEmpty":(r,e,t)=>new StringConverter(r).convertIsEmptyCall(e,t)})}}exports.StringConverter=StringConverter;
//# sourceMappingURL=string-converter.js.map