import * as estree from 'estree';
import { Converter } from '../converter';
import { BasicConversionResult } from '../types';
/**
 * Converts string properties and method calls to SQL.
 */
export declare class StringConverter {
    readonly converter: Converter;
    constructor(converter: Converter);
    convertArgs: (args: estree.BaseExpression[], types: import("../types").ConversionResultType[], name: string) => BasicConversionResult[];
    /**
     * Converts a string property to SQL.
     * @param result - The string conversion result.
     * @param memberName - The name of the string property.
     * @returns The converted property as a SQL result.
     */
    convertLengthProperty(result: BasicConversionResult): BasicConversionResult;
    /**
     * Converts a string method call to SQL.
     *
     * @param result - The string conversion result.
     * @param methodName - The name of the method being called.
     * @param args - The arguments passed to the method call.
     * @returns The SQL result.
     */
    private convertTrimCall;
    private convertLikeFunction;
    /**
     * Converts a string.startsWith call to SQL.
     * @param result - The string conversion result.
     * @param args - The arguments passed to the method call.
     * @returns The SQL result.
     */
    private convertStartsWithCall;
    /**
     * Converts a string.endsWith call to SQL.
     * @param result - The string conversion result.
     * @param args - The arguments passed to the method call.
     * @returns The SQL result.
     */
    private convertEndsWithCall;
    /**
     * Converts a string.includes call to SQL.
     * @param result - The string conversion result.
     * @param args - The arguments passed to the method call.
     * @returns The SQL result.
     */
    private convertIncludesCall;
    private convertIsEmptyCall;
    convertToChar(result: BasicConversionResult): string;
    static register(): void;
}
//# sourceMappingURL=string-converter.d.ts.map