/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.RegExpConverter=void 0;const conversion_error_1=require("../conversion-error");class RegExpConverter{constructor(e){this.converter=e}convertPostgres(e,r,t){return{type:"boolean",sql:`ARRAY_LENGTH(REGEXP_MATCH(${t}, ${e}, ${r}), 1) > 0`}}convertOracle(e,r,t){return{type:"boolean",sql:`REGEXP_LIKE(${t},${e},${r})`}}convertSqlServerRegexToSql(e){if("sqlServer"!==this.converter.dialect)return e;const sanitizeSqlPattern=(e,r)=>e.replace(/(\\.|\.\*?|%|_|\*)/g,(e,t)=>{if("\\"===t[0])return"$"===t[1]?"$$":t[1];if("."===t[0])return 2===t.length?"%":"_";if("%"===t||"_"===t)return`$${t}`;throw new Error(`${r}: regular expression cannot be converted to SQL: * must be escaped`)}),r="^"===e[0];let t=r?e.substring(1):e;const o=/(^|[^\\])(\\\\)*\$$/.test(e);t=o?t.substring(0,t.length-1):t;const n=/(?:^|[^\\])([\^\$\+\?\|\(\)\{\}\[\]]|\\\w)/.exec(t);if(n)throw new Error(`${e}: regular expression cannot be converted to SQL: ${n[1]} must be escaped`);let s=sanitizeSqlPattern(t,e);if(!r)s=`%${s}`;if(!o)s=`${s}%`;return s}convertSqlServer(e,r,t,o){const n=r.indexOf("i")>=0||o?.isParam?"COLLATE Latin1_General_CI_AS":"COLLATE Latin1_General_CS_AS";let s="";if(o?.isParam)s=`${t} ${n} LIKE ${e} escape '$'`;else s=`${t} ${n} LIKE ${this.converter.convertLiteral(this.convertSqlServerRegexToSql(e)).sql} escape '$'`;return{type:"boolean",sql:s}}convertRegex(e,r,t,o){const n=this.converter.stringConverter.convertToChar(t);let s="",c=r;if(!o?.isParam){if("sqlServer"!==this.converter.dialect)s=this.converter.convertLiteral(e).sql,c=this.converter.convertLiteral(r??"").sql}else s=e;switch(this.converter.dialect){case"postgres":return this.convertPostgres(s,c,n);case"oracle":return this.convertOracle(s,c,n);case"sqlServer":return this.convertSqlServer(e,r,n,o);default:throw new conversion_error_1.ConversionError(void 0,`Unsupported dialect: ${this.converter.dialect}`)}}convertMethodCall(e,r,t,o){if("test"!==t)throw new conversion_error_1.ConversionError(e,"Unsupported RegExp method");if(1!==o.length)throw new conversion_error_1.ConversionError(e,`${t}: cannot convert to SQL: expected 1 argument, got ${o.length}`);const n=o[0],s=this.converter.convertExpression(n),c=r.source,i=r.flags;return this.convertRegex(c,i,s)}}exports.RegExpConverter=RegExpConverter;
//# sourceMappingURL=regexp-converter.js.map