import * as estree from 'estree';
import { Converter } from '../converter';
import { BasicConversionResult } from '../types';
/**
 * Converts date expressions to SQL.
 */
export declare class DecimalConverter {
    private readonly converter;
    constructor(converter: Converter);
    /**
     * Converts a static method call on DateValue to SQL.
     *
     * @param identifier - The name of the static method being called.
     * @param args - The arguments passed to the static method.
     * @returns The result of the conversion.
     */
    convertStaticRoundAtCall(expression: estree.CallExpression, args: estree.BaseExpression[]): BasicConversionResult;
    static register(): void;
}
//# sourceMappingURL=decimal-converter.d.ts.map