/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlServerDateConverter=void 0;const conversion_error_1=require("../../conversion-error"),date_converter_1=require("./date-converter");class SqlServerDateConverter extends date_converter_1.DateConverter{constructor(){super(...arguments),this.dateSqlFields={epoch:e=>`DATEDIFF(SECOND, '1970-01-01', ${e})`,year:e=>`DATEPART(yy FROM ${e})`,month:e=>`DATEPART(mm FROM ${e})`,day:e=>`DATEPART(dd FROM ${e})`,week:e=>`DATEPART(isowk FROM ${e})`,weekDay:e=>`((DATEPART(dw FROM ${e}) + @@DATEFIRST + 6) % 7 )`,yearDay:e=>`DATEPART(dy FROM ${e})`,isLeapYear:e=>`((${this.dateSqlFields.year(e)} % 4 = 0 AND ${this.dateSqlFields.year(e)} % 100 <> 0) OR ${this.dateSqlFields.year(e)} % 400 = 0)`},this.currentDate="GETDATE()"}convertAddIntervalCall(e,r,t,a){const[s]=this.convertArgs(r,["integer"],`date.${t}`);let o="";switch(a){case"year":o=`DATEADD(year, ${s.sql}, ${e.sql})`;break;case"month":o=`DATEADD(month, ${s.sql}, ${e.sql})`;break;case"week":o=`DATEADD(week, ${s.sql}, ${e.sql})`;break;default:throw new conversion_error_1.ConversionError(void 0,`${this.dialect}: cannot convert call to date method ${t} to SQL for interval ${a}`)}return{...e,type:"date",sql:o}}convertAddDaysCall(e,r){const[t]=this.convertArgs(r,["integer"],"date.addDays"),a=`DATEADD(day, ${t.sql}, ${e.sql})`;return{...e,type:"date",sql:a}}convertDaysDiffCall(e,r){const[t]=this.convertArgs(r,["date"],"date.daysDiff"),a=`DATEDIFF(day, ${t.sql}, ${e.sql})`;return{...e,type:"integer",sql:a}}convertDaysInMonthCall(e,r){this.convertArgs(r,[],"date.daysInMonth");const t=`DAY(DATEADD(DD,-1,DATEADD(MM,DATEDIFF(MM,-1,${e.sql}),0)))`;return{...e,type:"integer",sql:t}}convertBegOfIntervalCall(e,r,t,a){this.convertArgs(r,[],`date.${t}`);let s="";switch(a){case"year":s=`DATEADD(YEAR, DATEDIFF(YEAR, 0, ${e.sql}), 0)`;break;case"month":s=`DATEADD(MONTH, DATEDIFF(MONTH, 0, ${e.sql}), 0)`;break;case"week":s=`DATEADD(WEEK, DATEDIFF(WEEK, 0, ${e.sql}), 0)`;break;case"quarter":s=`DATEADD(QUARTER, DATEDIFF(QUARTER, 0, ${e.sql}), 0)`;break;default:throw new conversion_error_1.ConversionError(void 0,`${this.dialect}: cannot convert call to date method ${t} to SQL for interval ${a}`)}return{...e,type:"date",sql:s}}convertEndOfIntervalCall(e,r,t,a){this.convertArgs(r,[],`date.${t}`);let s="";switch(a){case"year":s=`DATEADD(YEAR, DATEDIFF(YEAR, 0, ${e.sql}) + 1, -1)`;break;case"month":s=`DATEADD(MONTH, DATEDIFF(MONTH, 0, ${e.sql}) + 1, -1)`;break;case"week":s=`DATEADD(WEEK, DATEDIFF(WEEK, 0, ${e.sql}) + 1, -1)`;break;case"quarter":s=`DATEADD(QUARTER, DATEDIFF(QUARTER, 0, ${e.sql}) + 1, -1)`;break;default:throw new conversion_error_1.ConversionError(void 0,`${this.dialect}: cannot convert call to date method ${t} to SQL for interval ${a}`)}return{...e,type:"date",sql:s}}convertToChar(e,r){return`CONVERT(VARCHAR,${e.sql},${r||"23"})`}convertToDate(e,r=false){return`CONVERT(${r?"DATETIME":"DATE"},${e},${r?127:20})`}convertCompareCall(e,r){const[t]=this.convertArgs(r,["date"],"date.compare"),a=`DATEDIFF(day, ${t.sql}, ${e.sql})`;return{...e,type:"integer",sql:a}}}exports.SqlServerDateConverter=SqlServerDateConverter;
//# sourceMappingURL=sql-server-date-converter.js.map