/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PostgresDateConverter=void 0;const date_converter_1=require("./date-converter");class PostgresDateConverter extends date_converter_1.DateConverter{constructor(){super(...arguments),this.dateSqlFields={epoch:e=>`date_part('epoch', ${e})`,year:e=>`date_part('year', ${e})`,month:e=>`date_part('month', ${e})`,day:e=>`date_part('day', ${e})`,week:e=>`date_part('week', ${e})`,weekDay:e=>`date_part('dow', ${e})`,yearDay:e=>`date_part('doy', ${e})`,isLeapYear:e=>`(date_part('day', make_date(date_part('year', ${e})::int, 3, 1) - '1 day'::interval) = 29)`},this.currentDate="CURRENT_DATE"}convertAddIntervalCall(e,t,r,a){const[n]=this.convertArgs(t,["integer"],`date.${r}`),s=`(${e.sql} + (${n.sql}::INT4 || ' ' || '${a}')::interval)::DATE`;return{...e,type:"date",sql:s}}convertAddDaysCall(e,t){const[r]=this.convertArgs(t,["integer"],"date.addDays"),a=`(${e.sql} + ${r.sql}::INT4)::DATE`;return{...e,type:"date",sql:a}}convertDaysDiffCall(e,t){const[r]=this.convertArgs(t,["date"],"date.daysDiff"),a=`(${e.sql} - ${r.sql})::INT4`;return{...e,type:"integer",sql:a}}convertDaysInMonthCall(e,t){this.convertArgs(t,[],"date.daysInMonth");const r=`(date_part('day', date_trunc('month', ${e.sql}) + interval '1 month - 1 day'))`;return{...e,type:"integer",sql:r}}convertBegOfIntervalCall(e,t,r,a){this.convertArgs(t,[],`date.${r}`);const n=`date_trunc('${a}', ${e.sql})::DATE`;return{...e,type:"date",sql:n}}convertEndOfIntervalCall(e,t,r,a){this.convertArgs(t,[],`date.${r}`);let n=`1 ${a}`;if("quarter"===a)n="3 months";const s=`(date_trunc('${a}', ${e.sql}) + interval '${n} - 1 day')`;return{...e,type:"date",sql:s}}convertToChar(e,t){return`TO_CHAR(${e.sql},'${t??"YYYY-MM-DD"}')`}convertToDate(e,t=false){if(t)return`TO_TIMESTAMP(${e},'YYYY-MM-DD HH24:MI:SS') AT TIME ZONE 'UTC'`;return`TO_DATE(${e},'YYYY-MM-DD')`}}exports.PostgresDateConverter=PostgresDateConverter;
//# sourceMappingURL=postgres-date-converter.js.map