import * as estree from 'estree';
import { BasicConversionResult } from '../../types';
import { DateConverter, DateFunctions, DateInterval } from './date-converter';
/**
 * Converts date expressions to SQL.
 */
export declare class OracleDateConverter extends DateConverter {
    dateSqlFields: Record<DateFunctions, (from: string) => string>;
    readonly currentDate = "SYSDATE";
    convertAddIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
    convertAddDaysCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    convertDaysDiffCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    convertDaysInMonthCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    convertBegOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
    convertEndOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
    /**
     * convert to char
     * @param sql
     */
    convertToChar(result: BasicConversionResult, format?: string): string;
    /**
     * convert to date/datetime UTC format
     * @param sql
     * @param dateTime - true if the conversion is to a datetime
     */
    convertToDate(sql: string, dateTime?: boolean): string;
}
//# sourceMappingURL=oracle-date-converter.d.ts.map