/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.DateConverter=void 0;const conversion_error_1=require("../../conversion-error"),registry_1=require("../../registry");class DateConverter{constructor(e){this.converter=e,this.convertArgs=this.converter.convertArgs.bind(this.converter)}get dialect(){return this.converter.dialect}datePart(e,t){if("value"===e)return{type:"integer",sql:`(${this.datePart("year",t).sql} * 10000 + ${this.datePart("month",t).sql} * 100 + ${this.datePart("day",t).sql})`};const r=this.dateSqlFields[e](t);if("isLeapYear"===e)return{type:"boolean",sql:r};return{type:"integer",sql:r}}convertDateProperty(e,t){const r=e.sql;if(t in this.dateSqlFields||"value"===t)return this.datePart(t,r);throw new conversion_error_1.ConversionError(void 0,`${e.path}.${t}: invalid date property`)}convertProperty(e,t){return this.convertDateProperty(e,t)}convertStaticDateParse(e,t){if(1!==t.length)throw new conversion_error_1.ConversionError(e,`Date.parse: expected 1 argument, got ${t.length}`);return this.converter.cast(this.converter.convertExpression(t[0]),"date")}convertStaticDateToday(e,t){if(0!==t.length)throw new conversion_error_1.ConversionError(e,`Date.today: expected 0 arguments, got ${t.length}`);return{type:"date",sql:this.currentDate}}convertCompareCall(e,t){const[r]=this.convertArgs(t,["date"],"date.compare");return{...e,type:"integer",sql:`(${e.sql} - ${r.sql})`}}convertEqualsCall(e,t){const[r]=this.convertArgs(t,["date"],"date.equals");return{...e,type:"boolean",sql:`(${e.sql} = ${r.sql})`}}convertIsBetweenCall(e,t){const r=this.convertArgs(t,["date","date"],"date.isBetween");return{...e,type:"boolean",sql:`(${e.sql} BETWEEN ${r[0].sql} AND  ${r[1].sql})`}}convertIsLeapYearCall(e,t){return this.convertArgs(t,[],"date.isLeapYear"),{...e,type:"boolean",sql:this.dateSqlFields.isLeapYear(e.sql)}}convertIsWorkDayCall(e,t){return this.convertArgs(t,[],"date.isWorkDay"),{...e,type:"boolean",sql:`(${this.dateSqlFields.weekDay(e.sql)} NOT IN (0, 6))`}}static register(){registry_1.registry.registerBuiltInFunctions({"DateValue.parse":(e,t,r)=>e.dateConverter.convertStaticDateParse(t,r),"DateValue.today":(e,t,r)=>e.dateConverter.convertStaticDateToday(t,r),"date.parse":(e,t,r)=>e.dateConverter.convertStaticDateParse(t,r),"date.today":(e,t,r)=>e.dateConverter.convertStaticDateToday(t,r)}),registry_1.registry.registerMethods("date",{compare:(e,t,r)=>e.dateConverter.convertCompareCall(t,r),equals:(e,t,r)=>e.dateConverter.convertEqualsCall(t,r),isBetween:(e,t,r)=>e.dateConverter.convertIsBetweenCall(t,r),isLeapYear:(e,t,r)=>e.dateConverter.convertIsLeapYearCall(t,r),isWorkDay:(e,t,r)=>e.dateConverter.convertIsWorkDayCall(t,r),addYears:(e,t,r)=>e.dateConverter.convertAddIntervalCall(t,r,"addYears","year"),addMonths:(e,t,r)=>e.dateConverter.convertAddIntervalCall(t,r,"addMonths","month"),addDays:(e,t,r)=>e.dateConverter.convertAddDaysCall(t,r),addWeeks:(e,t,r)=>e.dateConverter.convertAddIntervalCall(t,r,"addWeeks","week"),daysDiff:(e,t,r)=>e.dateConverter.convertDaysDiffCall(t,r),daysInMonth:(e,t,r)=>e.dateConverter.convertDaysInMonthCall(t,r),begOfYear:(e,t,r)=>e.dateConverter.convertBegOfIntervalCall(t,r,"begOfYear","year"),begOfQuarter:(e,t,r)=>e.dateConverter.convertBegOfIntervalCall(t,r,"begOfQuarter","quarter"),begOfMonth:(e,t,r)=>e.dateConverter.convertBegOfIntervalCall(t,r,"begOfMonth","month"),begOfWeek:(e,t,r)=>e.dateConverter.convertBegOfIntervalCall(t,r,"begOfWeek","week"),endOfYear:(e,t,r)=>e.dateConverter.convertEndOfIntervalCall(t,r,"endOfYear","year"),endOfQuarter:(e,t,r)=>e.dateConverter.convertEndOfIntervalCall(t,r,"endOfQuarter","quarter"),endOfMonth:(e,t,r)=>e.dateConverter.convertEndOfIntervalCall(t,r,"endOfMonth","month"),endOfWeek:(e,t,r)=>e.dateConverter.convertEndOfIntervalCall(t,r,"endOfWeek","week")}),registry_1.registry.registerProperties("date",{epoch:(e,t)=>e.dateConverter.convertDateProperty(t,"epoch"),year:(e,t)=>e.dateConverter.convertDateProperty(t,"year"),month:(e,t)=>e.dateConverter.convertDateProperty(t,"month"),day:(e,t)=>e.dateConverter.convertDateProperty(t,"day"),week:(e,t)=>e.dateConverter.convertDateProperty(t,"week"),weekDay:(e,t)=>e.dateConverter.convertDateProperty(t,"weekDay"),yearDay:(e,t)=>e.dateConverter.convertDateProperty(t,"yearDay"),value:(e,t)=>e.dateConverter.convertDateProperty(t,"value"),isLeapYear:(e,t)=>e.dateConverter.convertDateProperty(t,"isLeapYear")})}}exports.DateConverter=DateConverter;
//# sourceMappingURL=date-converter.js.map