import { Dict } from '@sage/xtrem-shared';
import * as estree from 'estree';
import { Converter } from '../converter';
import { BasicConversionResult, GenericConversionResult } from '../types';
export interface CollectionWhereResult extends GenericConversionResult {
    extraType: 'collectionWhere';
    whereCallback: estree.ArrowFunctionExpression;
}
/**
 * Converts collection properties and method calls to SQL.
 */
export declare class CollectionConverter {
    private readonly converter;
    constructor(converter: Converter);
    private convertCollectionCallback;
    private convertQuantifiedCallback;
    private convertQuantifiedExpression;
    convertSumCallbacks(collection: GenericConversionResult, whereCallback: estree.ArrowFunctionExpression | undefined, sumCallback: estree.ArrowFunctionExpression): BasicConversionResult;
    private convertSumExpression;
    convertCollectionCallbacks(collection: GenericConversionResult, callbacks: Dict<estree.ArrowFunctionExpression>): {
        callbacksResults: Dict<BasicConversionResult>;
        aliases: string;
        joinCondition: string;
    };
    private convertTakeOneCallback;
    private convertWhereExpression;
    private convertWhereSumExpression;
    private convertTakeOneExpression;
    private convertLengthProperty;
    static register(): void;
}
//# sourceMappingURL=collection-converter.d.ts.map